# Coursebooks

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app, g
import pickle, platform, urllib, sys, json

import config


class Coursebooks:

    def __init__(self, lname):
        self.lname = lname

    f = """CREATE TABLE curriculum_course_books
(
  id_curriculum_course integer NOT NULL,
  bookid bigint NOT NULL,
  part smallint,
  num smallint,
  id serial NOT NULL,
  razdel character varying(100),
  CONSTRAINT curriculum_course_books_pkey PRIMARY KEY (id)
)

CREATE TABLE course_resources
(
  id serial NOT NULL,
  res_type smallint,
  title character varying,
  link character varying,
  publish_year smallint,
  mrid integer,
  library_book_id int,
  CONSTRAINT course_resources_pkey PRIMARY KEY (id)
)"""

    def getCourseBooks(self, id):
        conn = current_app.ms.db(self.lname).connect()
        sql = """select ccb.*, cr.res_type, cr.title, cr.link, cr.publish_year, cr.library_bookid, concat(:url , cr.library_bookid) as library_url from curriculum_course_books ccb join course_resources cr on ccb.bookid=cr.id where id_curriculum_course=:id"""
        stmt = text(sql)
        stmt = stmt.bindparams(url=current_app.ms.librarypublicurl(self.lname) + '/book/')
        stmt = stmt.bindparams(id=id)

        query = conn.execute(stmt)
        searchDetails = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return searchDetails

    def deleteCourseBok(self, id):

        conn = current_app.ms.db(self.lname).connect()

        sql = """delete from curriculum_course_books where id=:id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)
        return True

    def createCourseBook(self, id_curriculum_course, internal_bookid, dataDict):

        conn = current_app.ms.db(self.lname).connect()

        sql = """insert into curriculum_course_books (id_curriculum_course, bookid, part, num, razdel) values (:id_curriculum_course, :bookid, :part, :num, :razdel) returning id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id_curriculum_course=id_curriculum_course)
        stmt = stmt.bindparams(bookid=internal_bookid)
        stmt = stmt.bindparams(part=dataDict['part'])
        stmt = stmt.bindparams(num=dataDict['num'])
        stmt = stmt.bindparams(razdel=dataDict['razdel'])

        query = conn.execute(stmt)
        return True

    def editCourseBook(self, id, internal_bookid, dataDict):

        conn = current_app.ms.db(self.lname).connect()

        sql = """update curriculum_course_books set  bookid=:bookid, part=:part, num=:num, razdel=:razdel where id=:id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        stmt = stmt.bindparams(bookid=internal_bookid)
        stmt = stmt.bindparams(part=dataDict['part'])
        stmt = stmt.bindparams(num=dataDict['num'])
        stmt = stmt.bindparams(razdel=dataDict['razdel'])

        query = conn.execute(stmt)
        return True

    def bookExist(self, bookid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select * from course_resources cr  where library_bookid=:id"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=bookid)

        query = conn.execute(stmt)
        for row in query:
            return row.id

        return None

    def insertbook(self, idata, bookid):

        conn = current_app.ms.db(self.lname).connect()
        sql = """insert into curriculum_course_books (
            , num, razdel,id_curriculum_course, bookid) values (1,:title,:publish_year,:bookid) returning id"""
        stmt = text(sql)
        stmt = stmt.bindparams(title=idata.part)
        stmt = stmt.bindparams(num=idata.num)
        stmt = stmt.bindparams(bookid=bookid)
        query = conn.execute(stmt)
        for row in query:
            return row.id

    def insertresource(self, librarybook):

        conn = current_app.ms.db(self.lname).connect()
        sql = """insert into course_resources (res_type, title, publish_year, library_bookid) values (1,:title,:publish_year,:library_bookid) returning id"""
        stmt = text(sql)
        stmt = stmt.bindparams(title=librarybook['title'])
        stmt = stmt.bindparams(publish_year=librarybook['year'])
        stmt = stmt.bindparams(library_bookid=librarybook['bookid'])
        query = conn.execute(stmt)
        for row in query:
            return row.id

    def getBookFromLibrary(self, bookid):
        if current_app.ms.libraryurl(self.lname) == "":
            return None
        if current_app.ms.librarykey(self.lname) == "":
            return None

        url = None

        try:
            from urllib.request import Request, urlopen  # Python 3        
            url = current_app.ms.libraryurl(self.lname) + "/book/" + str(bookid)
        except ImportError:
            from urllib2 import Request, urlopen  # Python 2

            url = current_app.ms.libraryurl(self.lname) + "/book/" + str(bookid)

        try:
            req = Request(url)

            req.add_header('x-hlms-apikey', current_app.ms.libraryaccesskey(self.lname))
            req.add_header('x-hlms-apiuserid', g.user.mid)
            data = urlopen(req)
            read_data = data.read()
            return json.loads(read_data.decode("utf-8"))

        except Exception as e:
            return "Error (" + str(e) + ") in REQUEST ", 500
