from sqlalchemy import create_engine, text
from flask import current_app

class Division:
 
    def getDivisionList(self, lname):
        conn = current_app.ms.db(lname).connect()
        query = conn.execute("select id did, owner_dep, name from vw_divisions order by coalesce(owner_dep, 0), name;")
        divisionList = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return divisionList

    def getActiveDivisions(self, lname):
        conn = current_app.ms.db(lname).connect()
        query = conn.execute("""
            select struct_divisions.sdid, struct_divisions.divisionname, vw_divisions.name as parentname
                from struct_divisions
            join vw_divisions on f_owner = vw_divisions.id
            where struct_divisions.status = 0
        """)
        divisionList = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return divisionList

    def getAllowedDivisionList(self, lname, mid):
        conn = current_app.ms.db(lname).connect()
        stmt = text("""
            DROP TABLE IF EXISTS tmp_dep_list;
            CREATE TEMPORARY TABLE tmp_dep_list AS
            SELECT 
                id AS did,
                owner_dep,
                "name",
                id IN (SELECT depid FROM vw_staff WHERE is_main AND mid =:mid) AS user_dep
            FROM vw_divisions
            WHERE id IN (
                          SELECT DISTINCT UNNEST(pg.sdid)
                          FROM permission_groups pg
                          JOIN permission2mid p2m ON pg.pmid = p2m.pmid
                          WHERE p2m.mid = :mid
                        )
            ORDER BY COALESCE(owner_dep, 0), "name";
            UPDATE tmp_dep_list tdl
            SET owner_dep = NULL
            WHERE owner_dep NOT IN (SELECT did FROM tmp_dep_list WHERE did = tdl.owner_dep);
            SELECT * 
            FROM tmp_dep_list;
        """)
        query = conn.execute(stmt, {"mid": mid})
        divisionList = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return divisionList
