# coding=UTF-8
# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle


class Educationworkprogram:
    def __init__(self, cname):
        self.lname = cname

    def getEducationWorkProgram(
        self, idcurriculum, courseid, id_curriculum_course, paginateFrom, maxResults
    ):
        conn = current_app.ms.db(self.lname).connect()

        select_table = """select 
        cc.id_curriculum_course, 
        c.idcurriculum,
        courses.cid,
        cc.title as "Название",
        mp.shortname as "Воен.специальн.", 
        c.cname as "Учебный план", 
        concat_ws(' ' ,courses.course_index, courses.title) as "Дисциплина", 
        (SELECT bool_or(ccd.files) FROM  curriculum_course_details ccd WHERE ccd.id_curriculum_course = cc.id_curriculum_course) as "Файлы", 
        case cc.status when 1 then 'проект' when 2 then 'утвержденная' when 3 then 'архив' end as "Статус" """
        select_count = """SELECT COUNT(*)"""
        sql = """from curriculum_course as cc 
          inner join curriculum_detail cd on cd.id_curr_detail = cc.id_curr_detail 
          inner join curriculum c on c.idcurriculum = cd.idcurriculum 
          inner join qualif_demands qd on qd.q_demand_id = c.q_demand_id 
          inner join militaryprofession mp on mp.mpid = qd.mpid 
          inner join edu_direction ed on ed.edu_direct_id = mp.edu_direct_id 
          left outer join courses on courses.cid = cd.cid 
        where 1 = 1 """

        sql_table = select_table + sql
        sql_count = select_count + sql

        if id_curriculum_course is not None:
            sql_table += """ AND cc.id_curriculum_course =:id_curriculum_course """
            sql_count += """ AND cc.id_curriculum_course =:id_curriculum_course """
        else:
            if idcurriculum != 0:
                sql_table += """ AND c.idcurriculum =:idcurriculum """
                sql_count += """ AND c.idcurriculum =:idcurriculum """

            if courseid != 0:
                sql_table += """ AND  courses.cid = :courseid """
                sql_count += """ AND  courses.cid = :courseid """

        # Пагинация
        if paginateFrom is not None and maxResults is not None:
            sql_table += " LIMIT :maxResults" + " OFFSET :paginateFrom"
        elif maxResults is not None:
            sql_table += " LIMIT :maxResults"
        else:
            sql_table += """order by cc.title"""

        stmt = text(sql_table)
        stmt_count = text(sql_count)

        if id_curriculum_course is not None:
            stmt = stmt.bindparams(id_curriculum_course=id_curriculum_course)
            stmt_count = stmt_count.bindparams(
                id_curriculum_course=id_curriculum_course
            )
        else:
            if idcurriculum != 0:
                stmt = stmt.bindparams(idcurriculum=idcurriculum)
                stmt_count = stmt_count.bindparams(idcurriculum=idcurriculum)
            if courseid != 0:
                stmt = stmt.bindparams(courseid=courseid)
                stmt_count = stmt_count.bindparams(courseid=courseid)
        if paginateFrom is not None and maxResults is not None:
            stmt = stmt.bindparams(paginateFrom=paginateFrom)
            stmt = stmt.bindparams(maxResults=maxResults)
        elif maxResults is not None:
            stmt = stmt.bindparams(maxResults=maxResults)

        query = conn.execute(stmt_count)
        count = query.scalar()

        query = conn.execute(stmt)
        ewp = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        if id_curriculum_course is not None and len(ewp):
            return ewp[0]

        return {"count": count, "ewp": ewp}
