# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Educationplan:

    def __init__(self,cname):
        self.lname = cname

    def getEducationPlan(self,syid,mpid):
 
        conn = current_app.ms.db(self.lname).connect()
        
        sql = """SELECT DISTINCT c.idcurriculum as educationplanid,cname
 FROM studyyears2curriculum AS l 
 JOIN  curriculum            AS c ON c.idcurriculum = l.idcurriculum
 JOIN  qualif_demands        AS q ON q.q_demand_id = c.q_demand_id
 WHERE l.syid = :syid  AND q.mpid = :mpid"""

        stmt = text(sql)
        stmt = stmt.bindparams(mpid=mpid)    
        stmt = stmt.bindparams(syid=syid)    
        query = conn.execute(stmt)

        for row in query:
            data = {}
            data['educationplanid'] = row.educationplanid
            data['educationplanname'] = row.cname
    

            return data
        
        return {}