# coding=UTF-8
# LMSAPI/API/Journal.py
from flask import current_app, g
import pickle

from sqlalchemy import text


class EnrollQuestions:
    # Список возможных полей для таблицы EnrollQuestions кроме id
    possible_fields = [
        "question_type",
        "cid",
        "oid",
        "tlid",
        "question_text",
        "q_num",
        "q_name",
        "weight",
        "sample_answer",
        "id_parent",
        "q_pos",
        "sel_length",
        "req_solution",
        "multimedia",
        "status",
        "test",
        "eyid",
        "answer_id",
        "answer",
        "value",
    ]

    def get_enroll_questions_all(
        self, lname, question_type, cid, oid, tlid, eyid, status
    ):
        conn = current_app.ms.db(lname).connect()
        where = ""
        if question_type:
            where += " and question_type = :question_type "
        if cid:
            where += " and cid = :cid "
        if oid:
            where += " and oid = :oid "
        if tlid:
            where += " and tlid = :tlid "
        if eyid:
            where += " and eyid = :eyid "
        if status:
            where += " and status = :status "

        sql = """
            select * from enroll_questions
            where 1=1
            {where}
            """.format(
            where=where
        )

        stmt = text(sql)
        if question_type:
            stmt = stmt.bindparams(question_type=question_type)
        if cid:
            stmt = stmt.bindparams(cid=cid)
        if oid:
            stmt = stmt.bindparams(oid=oid)
        if tlid:
            stmt = stmt.bindparams(tlid=tlid)
        if eyid:
            stmt = stmt.bindparams(eyid=eyid)
        if status:
            stmt = stmt.bindparams(status=status)

        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_enroll_questions_by_id(self, lname, id):
        conn = current_app.ms.db(lname).connect()

        sql = """
            select * from enroll_questions
            where id = :id
            """
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)
        result = query.fetchone()

        if result is None:
            return None

        result_dict = dict(zip(query.keys(), result))
        return result_dict

    def create_enroll_questions(self, lname, data):
        conn = current_app.ms.db(lname).connect()

        params = {}
        for field in self.possible_fields:
            params[field] = data[field] if field in data else None

        sql = """
            insert into enroll_questions(question_type, cid, oid, tlid, question_text, q_num, q_name, weight, 
                                         sample_answer, id_parent, q_pos, sel_length, req_solution, multimedia, status, 
                                         test, eyid, answer_id, answer, value) 
            values (:question_type, :cid, :oid, :tlid, :question_text, :q_num, :q_name, :weight, :sample_answer, 
                    :id_parent, :q_pos, :sel_length, :req_solution, :multimedia, :status, :test, :eyid, :answer_id, 
                    :answer, :value) 
            returning id
            """
        stmt = text(sql)
        stmt = stmt.bindparams(**params)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def update_enroll_questions(self, lname, id, data):
        conn = current_app.ms.db(lname).connect()

        # Формируем SET выражение и параметры
        set_clauses = []
        params = {"id": id}

        for field in self.possible_fields:
            if data.get(field) is not None:
                set_clauses.append("{field} = :{field}".format(field=field))
                params[field] = data.get(field)

        # Проверяем, есть ли поля для обновления
        if not set_clauses:
            raise ValueError("No fields to update")

        # Формируем SQL запрос
        set_clause = ", ".join(set_clauses)
        sql = """
            UPDATE enroll_questions
            SET {set_clause}
            WHERE id = :id
            RETURNING id
        """.format(
            set_clause=set_clause
        )

        stmt = text(sql).bindparams(**params)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def delete_enroll_questions(self, lname, id):
        conn = current_app.ms.db(lname).connect()
        sql = """
            DELETE FROM enroll_questions
            WHERE id = :id
            RETURNING id
        """

        stmt = text(sql).bindparams(id=id)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
