# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle
import redis
from LMSAPI.api.Models.Redishshim import Redisshim


class Multiserver:

    def __init__(self):
        self.instance = {}
        self.apikey = {}
        self.valid = []

    def listPools(self):
        return self.valid

    def startPools(self, instances):
        for a in instances:
            self.instance[a['NAME']] = {}
            self.instance[a['NAME']]['db'] = create_engine(a['SQL'],pool_size=5,pool_recycle=6)

            if a['REDIS'] != "":            
                    self.instance[a['NAME']]['redis'] = redis.StrictRedis(host=a['REDIS'], port=a['REDISPORT'], db=0)
            else:
                    self.instance[a['NAME']]['redis'] = Redisshim()
                    
            self.instance[a['NAME']]['fileroot'] = a['FILEROOT']

            if 'LIBRARYKEY' in a:
                self.instance[a['NAME']]['librarykey'] = a['LIBRARYKEY']
                self.apikey[a['LIBRARYKEY']] = a['NAME']
            else:
                self.instance[a['NAME']]['librarykey'] = ""
            if 'LIBRARYURL' in a:
                self.instance[a['NAME']]['libraryurl'] = a['LIBRARYURL']
            else:
                self.instance[a['NAME']]['libraryurl'] = ""

            if 'LIBRARYPUBLICURL' in a:
                self.instance[a['NAME']]['librarypublicurl'] = a['LIBRARYPUBLICURL']
            else:
                self.instance[a['NAME']]['librarypublicurl'] = ""

            if 'APIKEY' in a:
                self.instance[a['NAME']]['apikey'] = a['APIKEY']
            else:
                self.instance[a['NAME']]['apikey'] = None

            self.valid.append(a['NAME'])
            

    def redis(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['redis']

        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)

    def fileroot(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['fileroot']
        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)

    def db(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['db']
        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)

    def validname(self,name):
        for a in self.valid:
            if a == name:
                return True
        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)

    def getapikey(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['apikey']
        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)
    
    def libraryaccesskey(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['librarykey']
        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)

    def libraryurl(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['libraryurl']
        current_app.logger.error("Attempt to get invalid company: " + name)
        raise NameError("No such company: " + name)

    def librarypublicurl(self,name):
        for a in self.valid:
            if a == name:
                return self.instance[a]['librarypublicurl']        
        return ""

    def librarykey(self,key):     
        try:
            return self.apikey[key]
        except KeyError:
            return None
        
        