# LMSAPI/API/Term.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app, g
import pickle

from LMSAPI.api.Models.Division import Division


class Orders:
    def __init__(self):
        self.idorder = 0
        self.ordernum = ""

    def serialize(self):
        return {
            "cid": self.idorder,
            "course": self.ordernum,
        }

    def getOrderTypes(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """select order_type_id, order_type 
        from order_types where doc_type = 'S' order by order_type;
                """

        stmt = text(sql)
        query = conn.execute(stmt)

        result = {
            "order_type": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        if len(result["order_type"]) == 0:
            return None

        return result

    def getOrderDate(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT DISTINCT date_part('year', orderdate) as idorderdate, date_part('year', orderdate) as ordd FROM orders 
        WHERE orderdate BETWEEN (SELECT MIN(orderdate) from orders) and (SELECT MAX(orderdate) from orders) and doc_type = 'S' ORDER BY ordd DESC
                """

        stmt = text(sql)
        query = conn.execute(stmt)

        result = {
            "order_date": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        if len(result["order_date"]) == 0:
            return None

        return result

    def getSRW(
            self,
            lname,
            # admin_flag,
            idorderdate,
            idfaculty,
            order_type_id,
            order_state,
            ordernum,
            by_user,
            mid,
            to_date,
            from_date,
            paginateFrom,
            maxResults,
    ):
        conn = current_app.ms.db(lname).connect()

        # id_faculty_list = [i['did'] for i in Division().getAllowedDivisionList(lname, g.user.mid)]
        # if idfaculty != 0 and not admin_flag and idfaculty not in id_faculty_list:
        #     return None

        sql = """
        SELECT 
            idorder, 
            order_type, -- "Вид работы" 
            ordernum, -- "Номер"
            COALESCE(xp_get_order_target(idorder),'Общеакадемический'), -- "Подразделения"
            orderdate, -- "Дата"
            order_state, -- "Статус"
            ord_close_date, -- "Дата закрытия"
            CASE 
                WHEN ord_init_mid IS NOT NULL 
                THEN xp_f_get_mid_fio(ord_init_mid, 1)  
                ELSE string_agg(fio ,',' ORDER BY fio) 
            END as executor, -- "Исполнитель"
            nir_instructor_id, -- "Научный руководитель"
            nir_subinstructor_id, -- "Заместитель научного руководителя"
            nir_main_executor, -- "Ответственный исполнитель"
            ord_content -- "Содержание"
        FROM (
            SELECT
                DISTINCT o.idorder,
                order_type,
                ordernum,
                okr_code,
                orderdate,
                CASE 
                    WHEN order_state 
                    THEN 'Действующий' 
                    ELSE 'Закрыт' 
                END order_state,
                ord_close_date, 
                xp_f_get_mid_fio(o.nir_instructor_id, 1) as nir_instructor_id,
                xp_f_get_mid_fio(o.nir_subinstructor_id, 1) as nir_subinstructor_id,
                xp_f_get_mid_fio(o.nir_main_executor, 1) as nir_main_executor,
                ord_content,
                ord_init_mid,
                fio 
            FROM orders o 
            LEFT JOIN order_types t ON (o.order_type_id = t.order_type_id)
            LEFT JOIN (
                    SELECT 
                        od1.f_order,
                        od1.f_sdid  AS fac 
                    FROM l_order_division od1 
                    UNION -------------------------
                    SELECT 
                        od2.f_order,
                        cs.faculty AS fac 
                    FROM l_order_division od2 
                    JOIN cathedras cs ON cs.idcathedra = od2.f_sdid & 268435455 --ид подразделения
                    WHERE od2.f_sdid & 805306368 = 536870912 
                    UNION -------------------------
                    SELECT 
                        od3.f_order, 
                        sdiv.f_owner AS fac 
                    FROM l_order_division od3 
                    JOIN struct_divisions sdiv ON sdiv.sdid = od3.f_sdid & 268435455
                    WHERE od3.f_sdid & 805306368 = 268435456 AND sdiv.f_owner & 805306368 = 0
                    UNION -------------------------
                    SELECT 
                        o2.idorder AS f_order,
                        o2.idfaculty AS fac 
                    FROM orders o2 
                    WHERE o2.idfaculty > 0 
                      ) od ON od.f_order = o.idorder 
            LEFT OUTER JOIN order_sub_type ost ON ost.order_sub_type = o.order_sub_type 
            LEFT JOIN (
                    SELECT
                        xp_f_get_mid_fio(op2.mid,1) as fio,
                        op2.idorder 
                    FROM people pp 
                    JOIN order_people op2 ON op2.mid=pp.mid
                    GROUP BY op2.idorder, xp_f_get_mid_fio(op2.mid,1), pp.lastname,pp.firstname,pp.patronymic
                    ORDER BY pp.lastname,pp.firstname,pp.patronymic
                    ) op ON op.idorder = o.idorder 
        WHERE 1 = 1 
        AND o.doc_type = 'S'
        """
        if idorderdate != 0 and to_date is None and from_date is None:  # год
            sql = sql + " AND date_part('year', orderdate) = :idorderdate "
        # if not admin_flag and idfaculty == 0:
        #     # если пользователь не имеет прав администратора
        #     sql = sql + " AND od.fac = ANY(:id_faculty_list) "
        elif idfaculty != 0:  # id подразделения
            sql = sql + " AND od.fac = :idfaculty "
        if order_type_id != 0:  # вид работы
            sql = sql + " AND o.order_type_id = :order_type_id "
        if order_state == 1:  # статус действующий
            sql = sql + " AND o.order_state "
        elif order_state == 2:  # статус закрыт
            sql = sql + " AND not(o.order_state) "
        if ordernum is not None and ordernum != "all":  # номер
            sql = sql + " AND ordernum like :ordernum "
        if by_user:
            sql += """
                AND (ord_init_mid = :mid 
                    OR o.nir_instructor_id = :mid 
                    OR o.nir_subinstructor_id = :mid 
                    OR o.nir_main_executor = :mid
                    OR o.idorder in (
                        SELECT idorder 
                        FROM order_people
                        WHERE mid = :mid
                    )) 
            """
        if to_date is not None and from_date is not None:
            sql += """ AND o.orderdate BETWEEN TO_DATE(:from_date, 'YYYY-MM-DD') AND TO_DATE(:to_date, 
            'YYYY-MM-DD')"""

        sql = (
                sql
                + """
            ORDER BY orderdate
            ) AS t 
            GROUP BY 
                idorder,
                ordernum,
                order_type,
                orderdate,
                order_state,
                ord_close_date,
                ord_init_mid,
                nir_instructor_id,
                nir_subinstructor_id,
                nir_main_executor,
                ord_content 
            ORDER BY 
                orderdate
            """
        )

        sql_count = (
                """SELECT COUNT(*) as row_count FROM (""" + sql + """) as sub_query;"""
        )
        if paginateFrom is not None and maxResults is not None:
            sql += " LIMIT :maxResults" + " OFFSET :paginateFrom"
        elif maxResults is not None:
            sql += " LIMIT :maxResults"

        stmt = text(sql)
        stmt_count = text(sql_count)
        if idorderdate != 0 and to_date is None and from_date is None:
            stmt = stmt.bindparams(idorderdate=idorderdate)
            stmt_count = stmt_count.bindparams(idorderdate=idorderdate)
        # if not admin_flag and idfaculty == 0:
        #     stmt = stmt.bindparams(id_faculty_list=id_faculty_list)
        #     stmt_count = stmt_count.bindparams(id_faculty_list=id_faculty_list)
        if idfaculty != 0:
            stmt = stmt.bindparams(idfaculty=idfaculty)
            stmt_count = stmt_count.bindparams(idfaculty=idfaculty)
        if order_type_id != 0:
            stmt = stmt.bindparams(order_type_id=order_type_id)
            stmt_count = stmt_count.bindparams(order_type_id=order_type_id)
        if ordernum is not None and ordernum != "all":
            stmt = stmt.bindparams(ordernum="%{}%".format(ordernum))
            stmt_count = stmt_count.bindparams(ordernum="%{}%".format(ordernum))
        if by_user is True:
            stmt = stmt.bindparams(mid=mid)
            stmt_count = stmt_count.bindparams(mid=mid)
        if to_date is not None and from_date is not None:
            stmt = stmt.bindparams(to_date=to_date)
            stmt_count = stmt_count.bindparams(to_date=to_date)
            stmt = stmt.bindparams(from_date=from_date)
            stmt_count = stmt_count.bindparams(from_date=from_date)
        if paginateFrom is not None and maxResults is not None:
            stmt = stmt.bindparams(paginateFrom=paginateFrom)
            stmt = stmt.bindparams(maxResults=maxResults)
        elif maxResults is not None:
            stmt = stmt.bindparams(maxResults=maxResults)

        query = conn.execute(stmt_count)
        count = query.scalar()

        query = conn.execute(stmt)
        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        if len(result) == 0:
            return None
        return {"count": count, "scientific_research_work_table": result}
