# LMSAPI/API/Room.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle


class Organization:
    def __init__(self):
        self.suborgs = []    # creates a new empty list for each dog
        self.id=None
        self.pid=None
        self.owner=None

    def setdata(self, name, id, pid, owner):
        self.name = name
        self.id = id
        self.pid = pid
        self.owner = owner

    def iterate(self, me, treeSource):
        self.name = me.name
        self.id = me.id
        self.pid = me.id
        if me.owner is not None:
            self.owner = me.owner
        else:
            self.owner = ""
            
        for ob in treeSource:
            if self.id == ob.pid:
                newOrg = Organization()
                newOrg.iterate(ob,treeSource)
                self.suborgs.append(newOrg)
        return self

    def add_suborg(self, suborg):
        self.suborgs.append(suborg)

    def serialize(self):  
        return {
        'name': self.name,
        'children': [suborg.serialize() for suborg in self.suborgs],
        'owner': self.owner
         }

    @staticmethod
    def delete_code_from_name(arr):
        for item in arr:
            if "." in item.get("name"):
                item["name"] = item.get("name").split('.')[1]
                if item.get("children"):
                    Organization.delete_code_from_name(item.get("children"))

    def getOrganizationItems(self, lname):

        otCache = current_app.ms.redis(lname).get('orgTree')
       
        if otCache is not None:
            orgTree = pickle.loads(otCache)
            return orgTree

        orgs = []

        conn = current_app.ms.db(lname).connect()

        #Perform query and return JSON data
        query = conn.execute("""SELECT d.*, xp_f_get_mid_fio(d.mid,0) as fio 
        FROM departments d 
        ORDER BY d.name, d.owner_did, d.sortorder, d.did >> 27 & 1 desc, d.name, d.did""")

        for row in query:            
            #current_app.logger.debug(row)
            org = Organization()
            org.setdata(row.name, row.did, row.owner_did, row.fio)
            orgs.append(org)
     
        orgTree = []

        for row in orgs:
            if not row.pid:
                o = Organization()
                o.iterate(row, orgs)
                orgTree.append(o)

        otCache = [org.serialize() for org in orgTree]
        serData = pickle.dumps(otCache)
        current_app.ms.redis(lname).setex('orgTree', 60, serData)

        # delete code from name
        # Organization.delete_code_from_name(otCache)

        return otCache
