from sqlalchemy.sql import text
from flask import current_app, g


class Report:
    def __init__(self, cname):
        self.lname = cname

    def list_report(self, mid):
        """
            Первая страница со списком отчетов,
            формируется на основе прав.
        """
        conn = current_app.ms.db(self.lname).connect()
        sqlt = """
        SELECT xp_rpt_id, name 
        FROM xp_report rep
        JOIN xp_access ac ON ac.report_id = rep.xp_rpt_id
        JOIN permission2mid pm ON pm.pmid = ac.role
        WHERE rep.enabled = 1 and pm.mid = :mid
        ORDER BY rep.category, rep.name
        """
        stmt = text(sqlt)
        stmt = stmt.bindparams(mid=mid)
        result = conn.execute(stmt)
        conn.close()

        return [dict(res) for res in result]



# t_standard_param = ('sp_date',  # - дата
#                     'sp_date_from_to',  # диапазон дат
#                     'sp_month',
#                     'sp_study_year', 'sp_study_year_all',  # год набора
#                     'sp_education_year', 'sp_education_year_all', 'sp_education_year_no',  # курс
#                     'sp_school_year', 'sp_school_year_all', 'sp_school_year_radio', 'sp_school_year_list',  # уч. год
#                     'sp_semester', 'sp_semester_all',  # семестр
#                     'sp_faculty', 'sp_faculty_all', 'sp_faculty_no',  # факультет
#                     'sp_cathedra', 'sp_cathedra_all', 'sp_cathedra_no',  # кафедра
#                     'sp_group', 'sp_group_all', 'sp_group_no', 'sp_group_cheks',  # уч. группа
#                     'sp_curriculum_label', 'sp_curriculum_all', 'sp_curriculum_tree_list',  # уч. план
#                     'sp_preparation_structure', 'sp_preparation_structure_all', 'sp_preparation_structure_list',  # (специалитет, бакалавриат, магистратура..)
#                     'sp_training_direction',  # специальность
#                     'sp_military_profession', 'sp_military_profession_no', 'sp_military_profession_all',  # военная специальность
#                     'sp_military_profession_checks', 'sp_military_district', 'sp_military_district_all',  # вонный округ
#                     'sp_student', 'sp_student_all',  # курсант
#                     'sp_student_category', 'sp_student_category_all',  # (курсант, слушатель, ...)
#                     'sp_student_applicant_category', 'sp_student_lector_category',
#                     'sp_lector', 'sp_lector_all',  # преподаватель
#                     'sp_building', 'sp_building_all',  # Здания (объекты УМБ)
#                     'sp_room', 'sp_room_all',  # Кабинеты
#                     'sp_discipline', 'sp_discipline_all',  # Предметы обучения
#                     'sp_term_grade_type', 'sp_exam_type', 'sp_grafik_variant', 'sp_grafik_source',
#                     'sp_check_box_common_01', 'sp_check_box_common_02', 'sp_military_reception', 'sp_grade_values',
#                     'sp_division', 'sp_division_all',  # Подразделения
#                     'sp_calendar_year', 'sp_cb_calendar_year',  # календарный год
#                     'sp_week',  # неделя
#                     'sp_year_radio', 'sp_set_analysis',
#                     'sp_candidats', 'sp_candidats_all',  # претенденты
#                     'sp_date_arrive', 'sp_time_arrive',
#                     'sp_education_level',  # (ВО, СПО, ДПО)
#                     'sp_commissariat', 'sp_date_depart', 'sp_term_arrive', 'sp_arrive_where',
#                     'sp_arrive_why', 'sp_arrive_reason', 'sp_place_collect', 'sp_passage',
#                     'sp_column_commission_visible', 'sp_sign_role_column_visible', 'sp_date_universal',
#                     'sp_universal_text', 'sp_student_type', 'sp_student_list', 'sp_photo_size', 'sp_schema',
#                     'sp_period_all', 'sp_type_intelligence', 'sp_days', 'sp_sort', 'sp_organization_structure',
#                     'sp_print_format')
