from datetime import datetime

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle
from LMSAPI.api.Models.File import File


class StudentProject:

    def __init__(self, cname):
        self.lname = cname

        self.id = None
        self.type = None
        self.student = None
        self.teacher = None
        self.cid = None
        self.issuedate = None
        self.duedate = None
        self.grade = None
        self.task = None
        self.result = None
        # status:
        # 0 "Черновик"
        # 1 "Выдано"
        # 2 "Новое"
        # 3 "Выполнено"
        # 4 "Закрыто"
        self.status = None

        self.taskfiles = []
        self.resultfiles = []
        self.studentreviews = []

    def getStudentProjects(self, trmid, mid, tid, cid, isTeacher, gid):  # cid - 0 , all projects , termid never 0

        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT sp.*, 
        CAST(concat(TRIM(te.LastName), ' ', TRIM(te.FirstName), ' ', TRIM(te.Patronymic))AS text) AS teachername,
        CAST(concat(TRIM(ts.LastName), ' ', TRIM(ts.FirstName), ' ', TRIM(ts.Patronymic))AS text) AS studentname,
        c.title AS coursetitle, c.alias AS coursealias
        FROM xp_student_project sp
        JOIN people te on te.mid = sp.teacher
        JOIN people ts on ts.mid = sp.student
        JOIN courses c on c.cid = sp.cid
        LEFT OUTER JOIN vw_group_terms t ON trmid = :trmid and gid = :gid
        WHERE (sp.issuedate BETWEEN t.term_begin AND t.term_end
        OR sp.duedate BETWEEN t.term_begin AND t.term_end)
        """

        mid = int(mid)

        if isTeacher == False or mid != 0:
            sql = sql + " and student=:mid "

        tid = int(tid)
        cid = int(cid)

        if tid != 0:
            current_app.logger.debug(tid)
            sql = sql + " and teacher=:tid"

        if cid != 0:
            current_app.logger.debug(cid)
            sql = sql + " and sp.cid=:cid"

        stmt = text(sql)
        # current_app.logger.debug(stmt)

        stmt = stmt.bindparams(trmid=trmid, gid=gid)

        if mid != 0:
            stmt = stmt.bindparams(mid=mid)

        if tid != 0:
            stmt = stmt.bindparams(tid=tid)

        if cid != 0:
            stmt = stmt.bindparams(cid=cid)

        query = conn.execute(stmt)

        studentprojects = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return studentprojects

    def getStudentProject(self, id):

        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT sp.* ,
        CAST(concat(TRIM(te.LastName), ' ', TRIM(te.FirstName), ' ', TRIM(te.Patronymic))AS text) AS teachername,
        CAST(concat(TRIM(ts.LastName), ' ', TRIM(ts.FirstName), ' ', TRIM(ts.Patronymic))AS text) AS studentname,
        c.title AS coursetitle, c.alias AS coursealias
        FROM xp_student_project sp
        JOIN people te ON te.mid = sp.teacher
        JOIN people ts ON ts.mid = sp.student
        JOIN courses c ON c.cid = sp.cid
        where xp_key=:id
        """
        stmt = text(sql)
        stmt = stmt.bindparams(id=id)
        query = conn.execute(stmt)

        for row in query:
            self.id = row.xp_key
            self.type = row.type
            self.student = row.student
            self.studentname = row.studentname
            self.teacher = row.teacher
            self.teachername = row.teachername
            self.cid = row.cid
            self.issuedate = row.issuedate
            self.duedate = row.duedate
            self.grade = row.grade
            self.task = row.task
            self.result = row.result
            self.status = row.status
            self.coursetitle = row.coursetitle
            self.coursealias = row.coursealias

        if self.id == None:
            return False

        return True

    def getStudentProjectData(self, id):

        if self.getStudentProject(id) == False:
            return None

        self.taskfiles = File(self.lname).getStudentProjectTaskDirectoryFiles(self.id)
        self.resultfiles = File(self.lname).getStudentProjectResultDirectoryFiles(self.id)

        self.getStudentProjectReviews()

        for review in self.studentreviews:
            review['reviewfiles'] = File(self.lname).getStudentProjectReviewDirectoryFiles(self.id, review['xp_key'])

        data = {
            'taskfiles': self.taskfiles,
            'resultfiles': self.resultfiles,
            'reviews': self.studentreviews,
            'id': self.id,
            'type': self.type,
            'studentmid': self.student,
            'studentname': self.studentname,
            'teachermid': self.teacher,
            'teachername': self.teachername,
            'cid': self.cid,
            'issuedate': self.issuedate,
            'duedate': self.duedate,
            'grade': self.grade,
            'task': self.task,
            'result': self.result,
            'status': self.status,
            'coursealias': self.coursealias,
            'coursetitle': self.coursetitle
        }
        return data

    def editStudentProject(self):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        UPDATE public.xp_student_project
        SET  type=:type, student=:student, teacher=:teacher, cid=:cid, issuedate=:issuedate, 
        duedate=:duedate, grade=:grade, task=:task, result=:result, status=:status
        WHERE xp_key=:id;"""
        stmt = text(sql)

        stmt = stmt.bindparams(id=self.id)
        stmt = stmt.bindparams(type=self.type)
        stmt = stmt.bindparams(student=self.student)
        stmt = stmt.bindparams(teacher=self.teacher)
        stmt = stmt.bindparams(cid=self.cid)
        stmt = stmt.bindparams(issuedate=self.issuedate)
        stmt = stmt.bindparams(duedate=self.duedate)
        stmt = stmt.bindparams(grade=self.grade)
        stmt = stmt.bindparams(task=self.task)
        stmt = stmt.bindparams(result=self.result)
        stmt = stmt.bindparams(status=self.status)
        conn.execute(stmt)

        return True

    def deleteStudentProject(self):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        DELETE FROM xp_student_project 
        WHERE xp_key=:id;"""
        stmt = text(sql)
        stmt = stmt.bindparams(id=self.id)
        conn.execute(stmt)

        return True

    def createStudentProject(self):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        INSERT INTO public.xp_student_project(
        type, student, teacher, cid, issuedate, duedate, grade, task, result, status)
        VALUES (:type, :student, :teacher, :cid, :issuedate, :duedate, :grade, :task, :result, :status);"""
        stmt = text(sql)

        stmt = stmt.bindparams(type=self.type)
        stmt = stmt.bindparams(student=self.student)
        stmt = stmt.bindparams(teacher=self.teacher)
        stmt = stmt.bindparams(cid=self.cid)

        issuedate = datetime.strptime(self.issuedate, "%Y-%m-%d")
        duedate = datetime.strptime(self.duedate, "%Y-%m-%d")
        if issuedate > duedate:
            stmt = stmt.bindparams(issuedate=duedate.strftime('%Y') + '-01-01')
        else:
            stmt = stmt.bindparams(issuedate=self.issuedate)
        stmt = stmt.bindparams(duedate=self.duedate)
        stmt = stmt.bindparams(grade=self.grade)
        stmt = stmt.bindparams(task=self.task)
        stmt = stmt.bindparams(result=self.result)
        stmt = stmt.bindparams(status=self.status)
        conn.execute(stmt)

        sql = "SELECT currval(pg_get_serial_sequence('xp_student_project','xp_key'))"
        stmt = text(sql)
        query = conn.execute(stmt)
        newId = 0
        for row in query:
            newId = row.currval

        return newId

    def getStudentProjectReviews(self):
        if self.id == None:
            return False

        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT xp_student_project_review.*,
                cast(concat(trim(te.LastName), ' ', trim(te.FirstName), ' ', trim(te.Patronymic))as text) AS teachername
        FROM xp_student_project_review 
        JOIN people te ON te.mid = xp_student_project_review.mid
        WHERE project=:project"""
        stmt = text(sql)
        stmt = stmt.bindparams(project=self.id)
        query = conn.execute(stmt)
        self.studentreviews = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return True

    def getStudentProjectReview(self, rid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        SELECT *
        FROM xp_student_project_review 
        JOIN people te ON te.mid = xp_student_project_review.mid
        WHERE xp_student_project_review.xp_key=:rid"""
        stmt = text(sql)
        stmt = stmt.bindparams(rid=rid)
        query = conn.execute(stmt)

        for row in query:
            self.srproject = row.project
            self.srmid = row.mid
            self.srid = row.xp_key
            self.srreview = row.review
            self.srreviewdate = row.reviewdate
            return True

        return False

    def createStudentProjectReview(self, mid, review):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        INSERT INTO public.xp_student_project_review(
        project, mid, review, reviewdate)
        VALUES ( :project, :mid, :review, now());"""
        stmt = text(sql)

        stmt = stmt.bindparams(project=self.id)
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(review=review)

        conn.execute(stmt)

        sql = "SELECT currval(pg_get_serial_sequence('xp_student_project_review','xp_key'))"
        stmt = text(sql)
        query = conn.execute(stmt)
        newId = 0
        for row in query:
            newId = row.currval

        return newId

    def editStudentProjectReview(self, review):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
        UPDATE xp_student_project_review SET review=:review, reviewdate=now()
        WHERE xp_key=:id"""
        stmt = text(sql)

        stmt = stmt.bindparams(id=self.srid)
        stmt = stmt.bindparams(review=review)
        conn.execute(stmt)

        return True

    def deleteStudentProjectReview(self, id):
        conn = current_app.ms.db(self.lname).connect()
        sql = """
        DELETE FROM public.xp_student_project_review
        WHERE xp_key=:id"""
        stmt = text(sql)

        stmt = stmt.bindparams(id=id)
        conn.execute(stmt)

        return True
