from flask import Flask,jsonify, request, current_app, g
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.BookSupply import BookSupply
from flask_cors import CORS


books_supply_api = Blueprint('books_supply_api', __name__)

CORS(books_supply_api)

@books_supply_api.route('/lms/api/v1.0/<lname>/booksupply/<int:id>', methods=['GET'])
@auth.login_required
def getBookSupply(lname,id):
    """GET to generate a list of endpoints and their docstrings"""

    if(request.args.get('flat')=="true"):
        result = BookSupply(lname).getBookSupply(id, True)
    else:
        result = BookSupply(lname).getBookSupply(id, False)

    if result is None:
        return jsonify(success=False),404
    return jsonify(result)