from flask import Flask,jsonify, g
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Camera import Camera
from flask_cors import CORS

camera_api = Blueprint('camera_api', __name__)

CORS(camera_api)

@camera_api.route('/lms/api/v1.0/<lname>/camera', methods=['GET'])
@auth.login_required
def getCameraList(lname):
    if(g.user.isTeacher == False):
        return jsonify(accessDenied=False),401
    
    cameraList = Camera.getCameraList(lname)
    
    if cameraList is None:
        return jsonify(success=False),404

    return jsonify(cameraList)   