from flask import Blueprint, request, jsonify
from flask_cors import CORS

from LMSAPI.api.Models.ComplexThematicPlanning import ComplexThematicPlanning
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.utils.access_utils import user_permission_modes
from LMSAPI.api.utils.request_utils import RequestUtils

complex_thematic_planning_api = Blueprint("complex_thematic_planning_api", __name__)

CORS(complex_thematic_planning_api)


@complex_thematic_planning_api.route(
    "/lms/api/v1.0/<lname>/complex_thematic_planning/<int:xp_key>/<int:idfaculty>/<int:idcurriculum>/<int:cid>",
    methods=["GET"],
)
@auth.login_required
@user_permission_modes("Справочники", "Комплексный тем.план (КТП) по дисциплинам", ["Нет"])
def get_complex_thematic_planning(
    lname, xp_key: int, idfaculty: int, idcurriculum: int, cid: int
):
    limit = request.args.get("limit")
    offset = request.args.get("offset")
    result = ComplexThematicPlanning.get_complex_thematic_planning(
        lname=lname,
        limit=limit,
        offset=offset,
        xp_key=xp_key,
        idfaculty=idfaculty,
        idcurriculum=idcurriculum,
        cid=cid,
    )
    return jsonify(result), 200
