from flask import Flask, jsonify, request, current_app, g
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Coursebooks import Coursebooks
from flask_cors import CORS
import json, sys

coursebooks_api = Blueprint('coursebooks_api', __name__)

CORS(coursebooks_api)


@coursebooks_api.route('/lms/api/v1.0/<lname>/coursebooks/<int:id_curriculum_course>', methods=['GET'])
@auth.login_required
def getBookCourses(lname, id_curriculum_course):
    result = Coursebooks(lname).getCourseBooks(id_curriculum_course)
    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@coursebooks_api.route('/lms/api/v1.0/<lname>/coursebooks/<int:id>', methods=['PUT'])
@auth.login_required
def putBookCourse(lname, id):
    if g.user.isTeacher == False:
        return jsonify("Access denied!"), 403

    data = request.data
    if sys.version_info[0] < 3:
        dataDict = json.loads(data)
    else:
        dataDict = json.loads(data.decode('utf-8'))

    library_bookid = None
    if 'library_bookid' in dataDict:
        library_bookid = dataDict['library_bookid']
    if (library_bookid == None):
        return jsonify("missing library_bookid parameter"), 502

    num = None
    if 'num' in dataDict:
        num = dataDict['num']
    if (num == None):
        return jsonify("missing num parameter"), 502

    part = None
    if 'part' in dataDict:
        part = dataDict['part']
    if (part == None):
        return jsonify("missing part parameter"), 502

    razdel = None
    if 'razdel' in dataDict:
        razdel = dataDict['razdel']
    if (razdel == None):
        return jsonify("missing razdel parameter"), 502

        # Check if book exist in db
    internal_bookid = Coursebooks(lname).bookExist(library_bookid)

    # If not, create locally with data from library
    if (internal_bookid == None):
        book_data = Coursebooks(lname).getBookFromLibrary(library_bookid)
        if book_data != None and not isinstance(book_data, tuple):
            internal_bookid = Coursebooks(lname).insertresource(book_data)
        elif isinstance(book_data, tuple):
            current_app.logger.error(book_data)

    if (internal_bookid == None):
        return jsonify("bad library_bookid parameter" + str(library_bookid)), 502

    result = Coursebooks(lname).editCourseBook(id, internal_bookid, dataDict)

    return jsonify(result)


@coursebooks_api.route('/lms/api/v1.0/<lname>/coursebooks/<int:id_curriculum_course>', methods=['POST'])
@auth.login_required
def postBookCourse(lname, id_curriculum_course):
    if g.user.isTeacher == False:
        return jsonify("Access denied!"), 403

    data = request.data
    if sys.version_info[0] < 3:
        dataDict = json.loads(data)
    else:
        dataDict = json.loads(data.decode('utf-8'))

    library_bookid = None
    if 'library_bookid' in dataDict:
        library_bookid = dataDict['library_bookid']
    if (library_bookid == None):
        return jsonify("missing library_bookid parameter"), 502

    num = None
    if 'num' in dataDict:
        num = dataDict['num']
    if (num == None):
        return jsonify("missing num parameter"), 502

    part = None
    if 'part' in dataDict:
        part = dataDict['part']
    if (part == None):
        return jsonify("missing part parameter"), 502

    razdel = None
    if 'razdel' in dataDict:
        razdel = dataDict['razdel']
    if (razdel == None):
        return jsonify("missing razdel parameter"), 502

        # Check if book exist in db
    internal_bookid = Coursebooks(lname).bookExist(library_bookid)

    # If not, create locally with data from library
    if (internal_bookid == None):
        book_data = Coursebooks(lname).getBookFromLibrary(library_bookid)
        if book_data != None and not isinstance(book_data, tuple):
            internal_bookid = Coursebooks(lname).insertresource(book_data)
        elif isinstance(book_data, tuple):
            current_app.logger.error(book_data)

    if (internal_bookid == None):
        return jsonify("bad library_bookid parameter" + str(library_bookid)), 502

    result = Coursebooks(lname).createCourseBook(id_curriculum_course, internal_bookid, dataDict)

    return jsonify(result)


@coursebooks_api.route('/lms/api/v1.0/<lname>/coursebooks/<int:id>', methods=['DELETE'])
@auth.login_required
def deleteBookCourse(lname, id):
    if g.user.isTeacher == False:
        return jsonify("Access denied!"), 403

    result = Coursebooks(lname).deleteCourseBok(id)

    return jsonify(result)
