from flask import jsonify
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.CP import CP
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

cp_api = Blueprint('cp_api', __name__)

CORS(cp_api)


@cp_api.route('/lms/api/v1.0/<lname>/current_performance/<termid>/<mid>/<cid>', methods=['GET'])
@auth.login_required
def getCP(lname, termid, mid, cid):
    """GET to generate a list of endpoints and their docstrings"""
    result = CP(lname).getCP(termid, mid, cid)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)
