from flask import Flask,jsonify, request, current_app, send_from_directory, g
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.EduDocs import EduDocs
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

edudocs_api = Blueprint('edudocs_api', __name__)

CORS(edudocs_api)

@edudocs_api.route('/lms/api/v1.0/<lname>/edudoctypes', methods=['GET'])
def getEduDocTypes(lname):
    result = EduDocs(lname).getEduDocTypeList()

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)

@edudocs_api.route('/lms/api/v1.0/<lname>/edudocownertypes', methods=['GET'])
def getEduDocOwnerTypes(lname):
    result = EduDocs(lname).getEduDocOwnerTypeList()

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)    


@edudocs_api.route('/lms/api/v1.0/<lname>/edudocs', methods=['GET'])
@auth.login_required
@user_permission_modes("Справочники", "Документы об образовании. Виды документов об образовании", ["Нет"])
def getEduDocs(lname):
    result = EduDocs(lname).getEduDocList(request.args)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)    


@edudocs_api.route('/lms/api/v1.0/<lname>/edudocs/<int:studentid>/<int:id>/files', methods=['GET'])
def getEduDocFileList(lname, studentid, id):
    result = EduDocs(lname).getEduDocFileList(studentid, id)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)       


@edudocs_api.route('/lms/api/v1.0/<lname>/edudocs/<int:studentid>/<int:id>/<filename>', methods=['GET'])
def getEduDocFile(lname, studentid, id, filename):
    file_path = EduDocs(lname).getEduDocBaseDirectory(studentid, id)
    ip_address = (
        request.headers.get('X-Forwarded-For') or
        request.headers.get('X-Real-IP') or
        request.environ.get("REMOTE_ADDR")
    )
    return File.send_from_directory(
        lname=lname,
        file_path=file_path,
        file_name=filename,
        action_source=request.environ.get("HTTP_USER_AGENT"),
        login=None,
        user_mid=None,
        ip_address=ip_address
    )