from flask import jsonify, request, current_app, g, send_from_directory
from flask import Blueprint
import json

from decimal import Decimal

from LMSAPI.api.Models.File import File
# from LMSAPI.api.Views.TokenAPI import auth
# from LMSAPI.api.Models.Cathedra import Cathedra
from flask_cors import CORS

from LMSAPI.api.Models.EducationStandards import EducationStandards
from LMSAPI.api.Views.TokenAPI import auth

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

edustands_api = Blueprint('edustands_api', __name__)

CORS(edustands_api)


# Get all train areas
@edustands_api.route('/lms/api/v1.0/<lname>/all_edu_stands', methods=['GET'])
def getAllEduStands(lname):
    """GET a list of train directions"""
    ES = EducationStandards(lname)
    result = ES.get_all_edu_stands()

    if result is None:
        return jsonify(success=False), 404

    for r in result:
        for key, value in r.items():
            if isinstance(value, Decimal):
                r[key] = float(value)

    return jsonify(result)

