import os
from flask import jsonify, request, current_app
from flask import Blueprint
from flask_cors import CORS
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.utils.file_converter import FileConverter
from LMSAPI.api.utils.request_utils import RequestUtils

converter_api = Blueprint('converter_api', __name__)

CORS(converter_api)

@converter_api.route("/lms/api/v1.0/<string:lname>/convert", methods=["POST"])
@auth.login_required
def convert(lname: str):
    if not FileConverter.check_package():
        return jsonify({"message": "imagemagick is not installed"}), 400

    data_dict = RequestUtils.get_body(request)
    file_path = data_dict.get("file_path")
    if not file_path:
        return jsonify({"message": "file_path is required"}), 400
    
    lservers = current_app.config.get("LMSSERVERS")
    lserver = next((lserver for lserver in lservers if lserver.get("NAME") == lname), None)
    file_root = lserver.get("FILEROOT")
    file_path = os.path.join(file_root, file_path)
    if not os.path.exists(file_path):
        return jsonify({"message": "file in file_path is not exists"}), 404
    
    density = data_dict.get("density")
    output_format = data_dict.get("output_format")
    output_file_dir = os.path.join(file_root, data_dict.get("output_file_dir", "") or "")
    FileConverter.convert(file_path, density, output_format, output_file_dir)
    return jsonify({"message": "success"})