from flask import Blueprint, request, g, jsonify
from flask_cors import CORS
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.UserActionLog import UserActionLog
from LMSAPI.api.Views.TokenAPI import auth


user_action_log_api = Blueprint('user_action_log_api', __name__)

CORS(user_action_log_api)


@user_action_log_api.route("/lms/api/v1.0/<string:lname>/user_action_log", methods=["GET"])
@auth.login_required
def get_action_logs(lname):

    permission = User.check_permission(
        lname=lname,
        mid=g.user.mid,
        rasdel="Журнал доступа к файлам",
        rasdel_parent="Справочники"
    )

    if not permission:
        return jsonify(
            "У пользователя {login} нет прав для выполнения этого запроса".format(
                login=g.user.id
            )
        ), 403
    
    result = UserActionLog.get_logs(lname)
    return jsonify(result), 200