import subprocess
import os, stat
from config import Config

def getJakarta():
    
    try:
        pkcs_lib = Config().PKCS11_MODULE
    except Exception as ex:
        pkcs_lib = None
        print(ex)

    if pkcs_lib is None:
        pkcs_lib = '/usr/lib/libjcPKCS11-2.so'

    args = ["pkcs11-tool",'--module='+pkcs_lib, '-T']            
    try:      
        gpgprocess = subprocess.Popen(args,stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        gpgprocess.wait()
        error = ""
        jakarta_serial = None
        jakarta_keyname =None
        for line in iter(gpgprocess.stdout.readline, b''):
            line = line.decode('ascii')  
            if(line.find("serial num")>=0):
                jakarta_serial = line.split(":")[1].strip()
            if(line.find("token label")>=0):
                jakarta_keyname = line.split(":")[1].strip()
        
        if gpgprocess.stderr is not None:
            for line in iter(gpgprocess.stderr.readline, b''):
                line = line.decode('ascii')  
                error = error + line

        
        if len(error) == 0:
            error = None
        return jakarta_serial,jakarta_keyname,error
    except Exception as ex:
        return None, None, str(ex)