/*
Восстанавливаем "пропавшие" индивидуальные планы HLMS-5832
*/
UPDATE individual_plans ip SET 
  cpid = (
           SELECT vs.id 
           FROM vw_staff vs 
           WHERE vs.mid = ip.mid 
             AND vs.positionid = ip.cpid 
             AND vs.depid = ip.depid
           ORDER BY vs.is_main
           LIMIT 1
         )
WHERE ip.id IN (
  SELECT DISTINCT ip.id --, ip.cpid
  FROM individual_plans ip
  JOIN positions pos ON	ip.cpid = pos.pid
  JOIN vw_staff vs ON	ip.depid = vs.depid	AND vs.mid = ip.mid
  LEFT JOIN vw_staff vs2 ON	ip.depid = vs.depid	AND vs.mid = ip.mid	AND ip.cpid = vs.id
  WHERE	vs2.id IS NULL
  );
/* восстановление последовательности */
SELECT setval('permission_groups_pmid_seq', COALESCE(MAX(pmid) + 1, 1), false) FROM permission_groups;
