# project/__init__.py
from flasgger import Swagger
# import logging
# from logging.handlers import RotatingFileHandler

from flask import Flask
from flask_httpauth import HTTPBasicAuth
from flask_sqlalchemy import SQLAlchemy
from flask_compress import Compress
from LMSAPI.api.Models.Multiserver import Multiserver

# optimize https://damyanon.net/post/flask-series-optimizations/
# https://gist.github.com/ibeex/3257877 logging
# https://github.com/libwilliam/flask-compress compression

import os
from flask_apscheduler import APScheduler
import config

db = SQLAlchemy()
scheduler = APScheduler()

COMPRESS_MIMETYPES = [
    "text/html",
    "text/css",
    "text/xml",
    "application/json",
    "application/javascript",
]
COMPRESS_LEVEL = 6
COMPRESS_MIN_SIZE = 500


def create_app():
    app = Flask(__name__)
    auth = HTTPBasicAuth()

    app_settings = os.getenv("APP_SETTINGS")
    # app_settings = config.DevelopmentConfig
    app.config.from_object(app_settings)
    app.config["SQLALCHEMY_TRACK_MODIFICATIONS"] = False
    compress = Compress()
    app.config["JSON_AS_ASCII"] = False

    from LMSAPI.api.Views.UserAPI import user_api

    app.register_blueprint(user_api)

    from LMSAPI.api.Views.OrganizationAPI import organization_api

    app.register_blueprint(organization_api)

    from LMSAPI.api.Views.TokenAPI import token_api

    app.register_blueprint(token_api)

    from LMSAPI.api.Views.FacultyAPI import faculty_api

    app.register_blueprint(faculty_api)

    from LMSAPI.api.Views.VersionAPI import version_api

    app.register_blueprint(version_api)

    from LMSAPI.api.Views.CathedraAPI import cathedra_api

    app.register_blueprint(cathedra_api)

    from LMSAPI.api.Views.GroupAPI import group_api

    app.register_blueprint(group_api)

    from LMSAPI.api.Views.YearAPI import year_api

    app.register_blueprint(year_api)

    from LMSAPI.api.Views.ScheduleAPI import schedule_api

    app.register_blueprint(schedule_api)

    from LMSAPI.api.Views.CourseAPI import course_api

    app.register_blueprint(course_api)

    from LMSAPI.api.Views.MetaCourseAPI import meta_course_api

    app.register_blueprint(meta_course_api)

    from LMSAPI.api.Views.JournalAPI import journal_api

    app.register_blueprint(journal_api)

    from LMSAPI.api.Views.StatusAPI import status_api

    app.register_blueprint(status_api)

    from LMSAPI.api.Views.UMKCourseAPI import umk_course_api

    app.register_blueprint(umk_course_api)

    from LMSAPI.api.Views.FileAPI import file_api

    app.register_blueprint(file_api)

    from LMSAPI.api.Views.SearchAPI import search_api

    app.register_blueprint(search_api)

    from LMSAPI.api.Views.CompanyAPI import company_api

    app.register_blueprint(company_api)

    from LMSAPI.api.Views.SettingsAPI import settings_api

    app.register_blueprint(settings_api)

    from LMSAPI.api.Views.GradebookAPI import gradebook_api

    app.register_blueprint(gradebook_api)

    from LMSAPI.api.Views.ProgressAPI import progress_api

    app.register_blueprint(progress_api)

    from LMSAPI.api.Views.MethodicalAPI import methodical_api

    app.register_blueprint(methodical_api)

    from LMSAPI.api.Views.MessageAPI import message_api

    app.register_blueprint(message_api)

    from LMSAPI.api.Views.OoopAPI import ooop_api

    app.register_blueprint(ooop_api)

    from LMSAPI.api.Views.OrdersAPI import orders_api

    app.register_blueprint(orders_api)

    from LMSAPI.api.Views.SpecialtyAPI import specialty_api

    app.register_blueprint(specialty_api)

    from LMSAPI.api.Views.CurriculumAPI import curriculum_api

    app.register_blueprint(curriculum_api)

    from LMSAPI.api.Views.PortfolioAPI import portfolio_api

    app.register_blueprint(portfolio_api)

    from LMSAPI.api.Views.CurrentPerformanceAPI import cp_api

    app.register_blueprint(cp_api)

    from LMSAPI.api.Views.HomeworkAPI import homework_api

    app.register_blueprint(homework_api)

    from LMSAPI.api.Views.TestAPI import test_api

    app.register_blueprint(test_api)

    from LMSAPI.api.Views.StudentProjectAPI import student_project_api

    app.register_blueprint(student_project_api)

    from LMSAPI.api.Views.LibraryAPI import library_api

    app.register_blueprint(library_api)

    from LMSAPI.api.Views.CoursebooksAPI import coursebooks_api

    app.register_blueprint(coursebooks_api)

    from LMSAPI.api.Views.LessonPlansAPI import lesson_plans_api

    app.register_blueprint(lesson_plans_api)

    from LMSAPI.api.Views.EducationWorkProgramAPI import educationworkprogram_api

    app.register_blueprint(educationworkprogram_api)

    from LMSAPI.api.Views.BookSupplyAPI import books_supply_api

    app.register_blueprint(books_supply_api)

    from LMSAPI.api.Views.RoomAPI import room_api

    app.register_blueprint(room_api)

    from LMSAPI.api.Views.RPDAPI import rpd_api

    app.register_blueprint(rpd_api)

    from LMSAPI.api.Views.RatingAPI import rating_api

    app.register_blueprint(rating_api)

    from LMSAPI.api.Views.EduDocsAPI import edudocs_api

    app.register_blueprint(edudocs_api)

    from LMSAPI.api.Views.DivisionAPI import division_api

    app.register_blueprint(division_api)

    from LMSAPI.api.Views.NewsAPI import news_api

    app.register_blueprint(news_api)

    from LMSAPI.api.Views.EducationStandardsAPI import edustands_api

    app.register_blueprint(edustands_api)

    from LMSAPI.api.Views.TrainingDirectionAPI import traindirs_api

    app.register_blueprint(traindirs_api)

    from LMSAPI.api.Views.BuildingsAPI import buildings_api

    app.register_blueprint(buildings_api)

    from LMSAPI.api.Views.HeroesAPI import hero_api

    app.register_blueprint(hero_api)

    from LMSAPI.api.Views.CombatTrainingTasksAPI import combat_training_tasks_api

    app.register_blueprint(combat_training_tasks_api)

    from LMSAPI.api.Views.UserActionLogAPI import user_action_log_api

    app.register_blueprint(user_action_log_api)

    from LMSAPI.api.Views.DisciplinesAPI import disciplines_api

    app.register_blueprint(disciplines_api)

    from LMSAPI.api.Views.DisciplinesCoursesAPI import discipline_courses_api

    app.register_blueprint(discipline_courses_api)

    from LMSAPI.api.Views.EducationDirectionsAPI import education_directions_api

    app.register_blueprint(education_directions_api)

    from LMSAPI.api.Views.DemandsAPI import demands_api

    app.register_blueprint(demands_api)

    from LMSAPI.api.Views.DashboardAPI import dashboard_api

    app.register_blueprint(dashboard_api)

    from LMSAPI.api.Views.FileConverterAPI import converter_api

    app.register_blueprint(converter_api)

    from LMSAPI.api.Views.CronAPI import cron_api

    app.register_blueprint(cron_api)

    from LMSAPI.api.Views.ScientificWorkAPI import scientific_work_api

    app.register_blueprint(scientific_work_api)

    from LMSAPI.api.Views.CameraAPI import camera_api

    app.register_blueprint(camera_api)

    from LMSAPI.api.Views.PlansAPI import plans_api

    app.register_blueprint(plans_api)

    from LMSAPI.api.Views.ComplexThematicPlanningAPI import (
        complex_thematic_planning_api,
    )

    app.register_blueprint(complex_thematic_planning_api)

    from LMSAPI.api.Views.IndividualPlansAPI import individual_plans_api

    app.register_blueprint(individual_plans_api)

    from LMSAPI.api.Views.QuestionSetAPI import questionset_api

    app.register_blueprint(questionset_api)

    from LMSAPI.api.Views.EnrollQuestionsAPI import enroll_questions_api

    app.register_blueprint(enroll_questions_api)

    from LMSAPI.api.Views.EnrollAnswersAPI import enroll_answers_api

    app.register_blueprint(enroll_answers_api)

    from LMSAPI.api.Views.QuestionAnswersAPI import question_answers_api

    app.register_blueprint(question_answers_api)

    from LMSAPI.api.Views.ScholarshipListOptionsAPI import scholarship

    app.register_blueprint(scholarship)

    from LMSAPI.api.Views.MethodicalPlanAPI import methodical_plan_api

    app.register_blueprint(methodical_plan_api)

    from LMSAPI.api.Views.ImportApplicantAPI import import_applicant_api

    app.register_blueprint(import_applicant_api)

    from LMSAPI.api.Views.ApplicantAPI import applicant_api

    app.register_blueprint(applicant_api)

    from LMSAPI.api.Views.GPGAPI import gpg_api

    app.register_blueprint(gpg_api)

    from LMSAPI.api.Views.ReportAPI import report_api

    app.register_blueprint(report_api)

    from LMSAPI.api.Views.PreparationStructureAPI import preparation_structure_api

    app.register_blueprint(preparation_structure_api)

    from LMSAPI.api.Views.ScholarshipCandidatesFilesStorageAPI import scholarship_files_storage

    app.register_blueprint(scholarship_files_storage)

    from LMSAPI.api.Views.CriteriaTeacherEvaluationAPI import criteria_api

    app.register_blueprint(criteria_api)

    from LMSAPI.api.Views.TeacherReviewAPI import teacher_reviews_api

    app.register_blueprint(teacher_reviews_api)

    from LMSAPI.api.Views.LocalizationAPI import localization_api

    app.register_blueprint(localization_api)

    from LMSAPI.api.Views.AnnouncementAPI import announcement_api

    app.register_blueprint(announcement_api)

    from LMSAPI.api.Views.ScholarshipTreeAPI import scholarship_tree

    app.register_blueprint(scholarship_tree)

    from LMSAPI.api.Views.ScholarshipTypesAPI import scholarship_types

    app.register_blueprint(scholarship_types)

    from LMSAPI.api.utils.jakarta import getJakarta

    jakarta_serial, jakarta_keyname , jakarta_error= getJakarta()

    # app.e = create_engine(app.config['SQLALCHEMY_DATABASE_URI'],pool_size=5,pool_recycle=6)
    # app.redis = redis.StrictRedis(host=app.config['REDIS_SERVER'], port=app.config['REDIS_PORT'], db=0)
    # app.logger.debug('System startup')

    app.jakarta_serial = jakarta_serial
    app.jakarta_keyname = jakarta_keyname
    app.jakarta_error = jakarta_error


    from LMSAPI.api.Views.VersionAPI import createChangeList

    cl = createChangeList()

    for a in cl:
        app.version = a["version"]

    app.ms = Multiserver()
    app.ms.startPools(app.config["LMSSERVERS"])
    # app.ms.startPools(config.Config.LMSSERVERS)

    # SCHEDULER
    scheduler.init_app(app)

    from LMSAPI.api.utils.crons import file_image_converter

    scheduler.add_job(
        id="file_image_converter",
        func=file_image_converter,
        trigger="cron",
        minute="*/30",
    )

    scheduler.start()


    from LMSAPI.api.utils.swagger_utils import SwaggerUtils, swagger_registry, finalize_swagger
    finalize_swagger(app)

    template = {
        "swagger": "2.0",
        "info": {
            "title": "HLMS API",
            "description": "API с BasicAuth авторизацией",
            "version": "1.0"
        },
        "securityDefinitions": {
            "basicAuth": {
                "type": "basic",
                "description": "Введите логин и пароль для авторизации"
            }
        },
        "tags": SwaggerUtils.tags,
        "paths": swagger_registry["paths"],  # <-- твои зарегистрированные пути
    }

    Swagger(app, template=template, config={
        "headers": [],
        "specs": [
            {
                "endpoint": 'apispec_1',
                "route": '/lms/api/apidocs/swagger.json',
                "rule_filter": lambda rule: True,  # показать все пути
                "model_filter": lambda tag: True,
            }
        ],
        "static_url_path": "/lms/api/flasgger_static",
        "swagger_ui": True,
        "specs_route": "/lms/api/apidocs"
    })

    # app.logger.debug('A value for debugging')
    # app.logger.warning('A warning occurred (%d apples)', 42)
    # app.logger.error('An error occurred')
    return app
