# coding=UTF-8
# LMSAPI/API/Applicant.py
import json
from datetime import datetime

from sqlalchemy.sql import text
from flask import current_app

"""
Категория кандидата
Все
граждане РФ, не проходившие военную службу, - в возрасте от 16 до 22 лет
граждане РФ, прошедшие военную службу, и военнослужащие, проходящие военную службу по призыву, - до достижения ими возраста 24 лет
военнослужащие, проходящие военную службу по контракту (кроме офицеров), - по истечении половины срока военной службы, указанного в первом контракте, для получения высшего образования,-до достижения ими возраста 25 лет
военнослужащие, проходящие военную службу по контракту (кроме офицеров), - по истечении половины срока военной службы, указанного в первом контракте, для получения среднего профессионального образования,-до достижения ими возраста 30 лет
кандидаты из числа офицеров
кандидаты из числа иностранных граждан
"""

class Applicant:
    def __init__(self, cname):
        self.lname = cname

    def get_import_applicants(self,args: dict):
        conn = current_app.ms.db(self.lname).connect()

        where ,sqlargs = self.applicant_filters(args)

        sql = """
            SELECT xp_key,
                CONCAT(COALESCE(Child_LastName, ''), ' ', COALESCE(Child_FirstName, ''), ' ', COALESCE(Child_MidName, '')) AS "ФИО",
                Date AS "Дата", F."ShortName" AS "Факультет для поступления",
                concat(MP.ShortName, ' ', MP.name) AS "Военная специальность",
                td.training_index || ' ' || td.training_direct AS "Направление подготовки",
                CASE WHEN A.state = 1 THEN 'Прибыл' WHEN A.state = 2 THEN 'Прошел испытания' WHEN A.state = 3 THEN 'Отказано' ELSE 'Новый' END Статус,
                whenarrived "Дата прибытия",
                IF(IsStudent = 0, '', 'Зачислен') AS "Зачислен", S.name AS "Год набора",
                IF(lawyer + medic + Psychologist + secretaryPC = 4, 'Есть', '') AS "Допуск",
                pers_file_nr AS "Рег. номер", number_in AS "Вх. номер", Child_Is_Docs_Sent AS "Документы отправлены"
                , group_nr AS "№ группы" 
            FROM xp_applicant A
            LEFT JOIN faculty F ON A.faculty = F.idfaculty
            LEFT JOIN studyyears S ON S.syid = A.studyyear
            LEFT JOIN militaryprofession MP ON MP.mpid = A."MilitaryProfession"
            LEFT JOIN training_directions td  ON td.training_direct_id = A.training_direct      {where}
            ORDER BY UPPER(CONCAT(COALESCE(Child_LastName, ''), ' ', COALESCE(Child_FirstName, ''), ' ', COALESCE(Child_MidName, '')))
            LIMIT :limit
            OFFSET :offset  
            """.format(where=where)
        stmt = text(sql)        
        query = conn.execute(stmt,sqlargs)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]


    def get_count_import_applicants(self,args: dict):
        conn = current_app.ms.db(self.lname).connect()

        where ,sqlargs = self.applicant_filters(args)

        sql = """
            SELECT COUNT(xp_key)
            FROM xp_applicant A
            LEFT JOIN faculty F ON A.faculty = F.idfaculty
            LEFT JOIN studyyears S ON S.syid = A.studyyear
            LEFT JOIN militaryprofession MP ON MP.mpid = A."MilitaryProfession"
            LEFT JOIN training_directions td  ON td.training_direct_id = A.training_direct     {where}
            """.format(where=where)
        stmt = text(sql)
        query = conn.execute(stmt,sqlargs)
        count = query.scalar()
        return count


    def applicant_filters(self,filters_dict: dict) -> str:
        sqlargs = {}
        sqlargs['limit'] = filters_dict.get("limit") if filters_dict.get("limit") else 100
        sqlargs['offset'] = filters_dict.get("offset") if filters_dict.get("offset") else 0
        result_where = " WHERE 1=1 "
        for param in filters_dict:
            if param == "studyyear" and int(filters_dict.get("studyyear")) != 0:
                result_where += " and studyyear=:studyyear "  #/lms/api/v1.0/<lname>/year/scy
                sqlargs['studyyear'] =  int(filters_dict.get("studyyear"))
            elif param == "category_aplicant":
                result_where += " and category_aplicant=:category_aplicant "  
                sqlargs['category_aplicant'] =  filters_dict.get("category_aplicant")                
            elif param == "edu_program":
                result_where += " and edu_program=:edu_program "  
                sqlargs['edu_program'] =  filters_dict.get("edu_program")                 
            elif param == "faculty": # /api/v1.0/studium/faculty
                result_where += " and A.faculty=:faculty "  
                sqlargs['faculty'] =  filters_dict.get("faculty")  
            elif param == "training_direct": #/lms/api/v1.0/<lname>/all_train_dirs
                result_where += " and A.training_direct=:training_direct "  
                sqlargs['training_direct'] =  filters_dict.get("training_direct")
            elif param == "isSCANstudent":
                if filters_dict.get("isSCANstudent")== "0":
                    result_where += ' and isstudent = 0'  
                if filters_dict.get("isSCANstudent") == "1":
                    result_where += ' and isstudent <> 0'                  
            elif param == "date_from":
                result_where += ' and "date"::date>=:date_from '
                sqlargs['date_from'] =  filters_dict.get("date_from") 
            elif param == "date_to":
                result_where += ' and "date"::date<=:date_to '
                sqlargs['date_to'] =  filters_dict.get("date_to") 

        return result_where,sqlargs