# LMSAPI/API/Term.py
from sqlalchemy.sql import text
from flask import current_app
from LMSAPI.api.Models.File import File


class CP:

    def __init__(self,cname):
        self.lname = cname

    def getCP(self,termid, mid, cid):

        conn = current_app.ms.db(self.lname).connect()
        q1 = """
        select nnz_fill_journalstudent_detail(:termid, :mid, :cid, '2018-09-01', '2018-09-01');
        WITH journal_data AS (
          SELECT jsd.*, 
                 CASE 
                   WHEN EXISTS (
                     SELECT 1 
                     FROM question_answers qa
                     WHERE qa.mid = :mid
                       AND qa.questionset = jsd.group_questionset
                   ) 
                   THEN TRUE 
                   ELSE FALSE 
                 END AS group_question_answers,
                CASE 
                   WHEN EXISTS (
                     SELECT 1 
                     FROM question_answers qa
                     WHERE qa.mid = :mid
                       AND qa.questionset = jsd.student_questionset
                   ) 
                   THEN TRUE 
                   ELSE FALSE 
                 END AS student_question_answers
          FROM JournalStudent_detail jsd
          WHERE jsd.instance > 0
        )
        SELECT * 
        FROM journal_data
        ORDER BY lessonfulldate;
        """

        stmt = text(q1)
        stmt = stmt.bindparams(termid=termid)
        stmt = stmt.bindparams(cid=cid)    
        stmt = stmt.bindparams(mid=mid)            
        query = conn.execute(stmt)

        cp = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        af = File(self.lname)
        for s in cp:            
            s['filesExist'] = af.homeworkFilesExist(mid, s['sheid'], s['instance']) or af.get_homework_student_fact_directory(mid, s['sheid'], s['instance'])
            s['resultFilesExist'] = af.homeworkResultFilesExist(mid, s['sheid'], s['instance'])
            s['groupFilesExist'] = af.groupHomeworkFilesExist(s['sheid'], s['instance']) or af.homework_fact_files_exist(s['sheid'], s['instance'])
            s['groupResultFilesExist'] = af.groupHomeworkResultFilesExist(mid, s['sheid'], s['instance'])
        return cp
