from flask import current_app
from sqlalchemy import text


class ComplexThematicPlanning:
    @staticmethod
    def get_complex_thematic_planning(
        lname: str,
        limit: int,
        offset: int,
        xp_key: int,
        idfaculty: int,
        idcurriculum: int,
        cid: int,
    ):
        conn = current_app.ms.db(lname).connect()

        select_count = """SELECT COUNT(*) as count"""

        select_sql = """
            select 
              ctp.id_ctp, 
              ctp.title as "КТП",
              c.cname as "Учебный план",
              concat_ws(' ', nullif(courses.course_index, ''), courses.title) as "Дисциплина",
              xp_fget_group_fullname(ctp.gid, ctp.id_school_year) as "Группа",
              ey.name as "Курс", 
              tl.name as "Семестр", 
              cast(coalesce(ctpi.hours, 0) + coalesce(sum(ctpsi.hours), 0) as integer) as "Часов" 
            """

        where = """
        from complex_thematic_planning ctp 
          inner join curriculum_course cc on cc.id_curriculum_course = ctp.id_curriculum_course
          inner join termslist tl on tl.tlid = ctp.id_termslist 
          inner join educationyears ey on ey.eyid = tl.eyid 
          inner join curriculum_detail cd on cd.id_curr_detail = any(cc.id_curr_details || cc.id_curr_detail)
          inner join curriculum c on c.idcurriculum = cd.idcurriculum 
          inner join qualif_demands qd on qd.q_demand_id = c.q_demand_id 
          inner join militaryprofession mp on mp.mpid = qd.mpid 
          inner join courses on courses.cid = cd.cid 
          inner join groupname gn on gn.gid=ctp.gid 
          inner join cathedras cat on cat.idcathedra=gn.idcathedra 
          left outer join ( 
            select id_ctp, coalesce(sum(hours), 0) as hours 
            from complex_thematic_planning_items 
            group by id_ctp) ctpi on ctpi.id_ctp = ctp.id_ctp 
          left outer join complex_thematic_planning_stream_groups ctpsg on ctpsg.gid = ctp.gid and ctpsg.id_curriculum_course = ctp.id_curriculum_course 
          left outer join complex_thematic_planning_stream ctps on ctps.id_ctps = ctpsg.id_ctps and ctps.id_term = ctp.id_term 
          left outer join ( 
            select id_ctps, coalesce(sum(hours), 0) as hours 
            from complex_thematic_planning_stream_items 
            group by id_ctps) ctpsi on ctpsi.id_ctps = ctps.id_ctps
        where
          ctp.id_school_year = :xp_key
        """

        if idfaculty != 0:
            where += """and coalesce(gn.idfaculty, cat.faculty) = :idfaculty """
        if idcurriculum != 0:
            where += """and c.idcurriculum = :idcurriculum """
        if cid != 0:
            where += """and courses.cid = :cid """

        select_count += where

        where += """group by ctp.id_ctp, ctp.title, c.cname, courses.course_index, courses.title, ctp.gid, ctp.id_school_year, ey.name, ey.number, tl.name, tl.sorting, ctpi.hours
        order by c.cname, courses.title, ey.number, tl.sorting, ctp.title"""
        where += " LIMIT {limit}".format(limit=limit) if limit else ""
        where += " OFFSET {offset}".format(offset=offset) if offset else ""

        select_sql += where

        stmt_count = text(select_count)
        stmt = text(select_sql)

        stmt = stmt.bindparams(xp_key=xp_key)
        stmt_count = stmt_count.bindparams(xp_key=xp_key)
        if idfaculty != 0:
            stmt = stmt.bindparams(idfaculty=idfaculty)
            stmt_count = stmt_count.bindparams(idfaculty=idfaculty)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
            stmt_count = stmt_count.bindparams(idcurriculum=idfaculty)
        if cid != 0:
            stmt = stmt.bindparams(cid=cid)
            stmt_count = stmt_count.bindparams(cid=cid)
        query = conn.execute(stmt_count)
        count = query.scalar()

        query = conn.execute(stmt)
        complex_thematic_planning = [
            dict(zip(tuple(query.keys()), i)) for i in query.cursor
        ]
        return {"count": count, "complex_thematic_planning": complex_thematic_planning}
