# coding=UTF-8
# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle


class Curriculum:
    def __init__(self, cname):
        self.lname = cname

    def getAllCurriculums(self):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select 
c.idcurriculum, c.cname as "Название", m.shortname as "Воен.специальн.",
e."Gen_GOS" as "Поколение", e.dir_reg_num as "ФГОС", q.d_num as "КТ",
COUNT(g.gid) as "Колич.групп"
from curriculum c
left join studyyears2curriculum  as s2c ON s2c.idcurriculum = c.idcurriculum 
inner join qualif_demands q on q.q_demand_id = c.q_demand_id
left join groupname g ON g.f_militaryprofession = q.mpid and g.syid = s2c.syid 
inner join militaryprofession m on q.mpid = m.mpid
left join edu_direction e on e.edu_direct_id = m.edu_direct_id
GROUP BY c.idcurriculum, c.cname, m.shortname, e."Gen_GOS", e.dir_reg_num, q.d_num 
ORDER BY c.cname"""

        stmt = text(sql)
        query = conn.execute(stmt)
        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return curriculum

    def getCurriculum(self, syid, mpid):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select distinct
c.idcurriculum, c.cname as "Название", m.shortname as "Воен.специальн.",
e."Gen_GOS" as "Поколение", e.dir_reg_num as "ФГОС", q.d_num as "КТ",
fac.faculty as "Факультет",  COUNT(g.gid) as "Колич.групп"
from curriculum c
left join studyyears2curriculum  as s2c ON s2c.idcurriculum = c.idcurriculum 
inner join qualif_demands q on q.q_demand_id = c.q_demand_id
left join groupname g ON g.f_militaryprofession = q.mpid and g.syid = s2c.syid 
inner join militaryprofession m on q.mpid = m.mpid
left join edu_direction e on e.edu_direct_id = m.edu_direct_id
left outer join (SELECT distinct f.faculty, l.f_militaryprofession as mpid  
                 FROM l_cath_milprof l   
                 left outer join cathedras ct on ct.idcathedra = l.f_cathedras    
                 left outer join faculty f on f.idfaculty = ct.faculty limit 1) fac ON fac.mpid = m.mpid  
left outer join StudyYears2curriculum s2 on c.idcurriculum = s2.idcurriculum 
left outer join StudyYears sy on s2.syid = sy.syid 

where 1=1 """

        if syid != 0:
            sql = sql + " AND sy.syid = :syid "
        if mpid != 0:
            sql = sql + " and m.mpid = :mpid "

        sql = (
            sql
            + """ GROUP BY c.idcurriculum, c.cname, m.shortname, e."Gen_GOS", e.dir_reg_num, q.d_num,  fac.faculty 
ORDER BY c.cname"""
        )

        stmt = text(sql)

        if syid != 0:
            stmt = stmt.bindparams(syid=syid)
        if mpid != 0:
            stmt = stmt.bindparams(mpid=mpid)
        query = conn.execute(stmt)

        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return curriculum

    def getCurriculumYears(self, idcurriculum):
        conn = current_app.ms.db(self.lname).connect()

        sql = """select sy.syid, sy.name yearname, number, 
COALESCE((select CASE WHEN StudyYears2curriculum_id = NULL THEN 0 ELSE 1 END
  from StudyYears2curriculum s2
  where (s2.syid = sy.syid) and (s2.idcurriculum = :idcurriculum)), 0) as Ok
from StudyYears sy
join school_year  s ON sy.school_year=s.xp_key
order by s.begDate desc """

        stmt = text(sql)
        stmt = stmt.bindparams(idcurriculum=idcurriculum)

        query = conn.execute(stmt)

        years = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return years

    def getCurriculumid(self, idcurriculum):
        conn = current_app.ms.db(self.lname).connect()

        sql = """SELECT c.cname, m.shortname, cat.cathedra, e.dir_reg_num fgosnum, e.dir_reg_date fgosdate, q.d_num plannum, q.d_date plandate,
         cast(intensity_unit_hrs as text)
        FROM curriculum c INNER JOIN qualif_demands q on q.q_demand_id = c.q_demand_id 
        LEFT OUTER JOIN militaryprofession m ON m.mpid = q.mpid 
        LEFT OUTER JOIN l_cath_milprof l on m.mpid = l.f_militaryprofession 
        LEFT OUTER JOIN cathedras cat ON l.f_cathedras = cat.idcathedra 
        LEFT OUTER JOIN edu_direction e ON e.edu_direct_id = m.edu_direct_id 
        WHERE idcurriculum=:idcurriculum"""

        stmt = text(sql)
        stmt = stmt.bindparams(idcurriculum=idcurriculum)

        query = conn.execute(stmt)

        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        if len(curriculum) == 0:
            return curriculum

        curriculum[0]["years"] = self.getCurriculumYears(idcurriculum)

        return curriculum

    def getCurriculumByFaculty(self, syid, mpid, idfaculty):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
                SELECT 
                    c.idcurriculum, 
                    c.cname as "Название", 
                    m.shortname as "Воен.специальн.",
                    e."Gen_GOS" as "Поколение", 
                    e.dir_reg_num as "ФГОС", 
                    q.d_num as "КТ",
                    fac.faculty as "Факультет",  
                    COUNT(g.gid) as "Колич.групп"
                FROM curriculum c
                LEFT JOIN studyyears2curriculum  as s2c ON s2c.idcurriculum = c.idcurriculum 
                INNER JOIN qualif_demands q ON q.q_demand_id = c.q_demand_id
                LEFT JOIN groupname g ON g.f_militaryprofession = q.mpid AND g.syid = s2c.syid 
                INNER JOIN militaryprofession m ON q.mpid = m.mpid
                LEFT JOIN edu_direction e ON e.edu_direct_id = m.edu_direct_id
                LEFT OUTER JOIN (SELECT distinct f.faculty, l.f_militaryprofession as mpid  
                    FROM l_cath_milprof l   
                    LEFT OUTER JOIN cathedras ct ON ct.idcathedra = l.f_cathedras    
                    LEFT OUTER JOIN faculty f ON f.idfaculty = ct.faculty  ) fac ON fac.mpid = m.mpid  
                LEFT OUTER JOIN StudyYears2curriculum s2 ON c.idcurriculum = s2.idcurriculum 
                LEFT OUTER JOIN StudyYears sy ON s2.syid = sy.syid 
                LEFT OUTER JOIN faculty fac_table ON fac_table.faculty = fac.faculty

                WHERE 1 = 1 """

        if syid != 0:
            sql = sql + " AND sy.syid = :syid "
        if mpid != 0:
            sql = sql + " and m.mpid = :mpid "
        if idfaculty != 0:
            sql = sql + " AND fac_table.idfaculty = :idfaculty "

        sql = (
            sql
            + """ GROUP BY c.idcurriculum, c.cname, m.shortname, e."Gen_GOS", e.dir_reg_num, q.d_num,  fac.faculty 
        ORDER BY c.cname"""
        )

        stmt = text(sql)

        if syid != 0:
            stmt = stmt.bindparams(syid=syid)
        if mpid != 0:
            stmt = stmt.bindparams(mpid=mpid)
        if idfaculty != 0:
            stmt = stmt.bindparams(idfaculty=idfaculty)
        query = conn.execute(stmt)

        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return curriculum

    def getLessonPlansCurriculumByYearFaculty(self, syid, idfaculty):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            SELECT clm.idCurriculum,clm.cname FROM curriculum clm 
             JOIN qualif_demands q ON q.q_demand_id=clm.q_demand_id 
              JOIN militaryprofession mp ON mp.mpid=q.mpid 
               JOIN groupname g ON g.f_militaryprofession=mp.mpid 
                JOIN group_history gh ON gh.gid=g.gid AND gh.school_year=:syid
               JOIN cathedras cs ON cs.idcathedra=g.idcathedra 
                JOIN faculty f ON f.idfaculty=coalesce(g.idfaculty,cs.faculty) AND (f.idfaculty=:idfaculty OR :idfaculty=0)
            GROUP BY clm.idCurriculum,clm.cname 
            ORDER BY clm.cname 
            """
        stmt = text(sql)

        stmt = stmt.bindparams(syid=syid)
        stmt = stmt.bindparams(idfaculty=idfaculty)
        query = conn.execute(stmt)

        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        return curriculum

    def get_curriculum_by_cathedra(self, cathedra_id):
        conn = current_app.ms.db(self.lname).connect()
        sql = """
            select distinct c.idcurriculum, c.cname 
            from curriculum c
              inner join qualif_demands qd on qd.q_demand_id = c.q_demand_id 
              inner join militaryprofession mp on mp.mpid = qd.mpid 
              inner join l_cath_milprof l on l.f_militaryprofession = qd.mpid 
              inner join cathedras cat on cat.idcathedra = l.f_cathedras 
            where 1=1 AND 
                CASE WHEN :cathedra_id = 0 THEN TRUE
                ELSE cat.idcathedra = :cathedra_id OR cat.idcathedra=0
                END
            order by c.cname 
            
        """
        stmt = text(sql)

        stmt = stmt.bindparams(cathedra_id=cathedra_id)

        query = conn.execute(stmt)

        curriculums = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return curriculums

    def getCurriculumByMetacourseCathedra(self, idcathedra, idmetacourse):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            SELECT clm.idcurriculum,clm.cname FROM ( 
            SELECT idcurriculum FROM curriculum_detail cd 
            JOIN courses crs ON crs.cid=cd.cid 
            WHERE crs.meta_course=:idmetacourse OR :idmetacourse=0 
            AND (:idcathedra=0 OR crs.meta_course IN (SELECT meta_course FROM l_mcourse_cathedra WHERE idcathedra=:idcathedra)) 
            GROUP BY cd.idcurriculum ) d 
            JOIN curriculum clm ON clm.idcurriculum=d.idcurriculum 
            ORDER BY clm.cname  
            """

        stmt = text(sql)
        stmt = stmt.bindparams(idcathedra=idcathedra)
        stmt = stmt.bindparams(idmetacourse=idmetacourse)
        query = conn.execute(stmt)

        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return curriculum

    def get_curriculum_for_complex_thematic_planning(self, idfaculty):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            select distinct c.idcurriculum, c.cname 
            from curriculum c
              inner join qualif_demands qd on qd.q_demand_id = c.q_demand_id 
              inner join militaryprofession mp on mp.mpid = qd.mpid 
              inner join l_cath_milprof l on l.f_militaryprofession = qd.mpid 
              inner join cathedras cat on cat.idcathedra = l.f_cathedras 
            where cat.faculty = :idfaculty OR :idfaculty=0 
            order by c.cname
            """

        stmt = text(sql)
        stmt = stmt.bindparams(idfaculty=idfaculty)
        query = conn.execute(stmt)

        curriculum = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return curriculum

    def get_curriculum_by_umk_teacher(self, xp_key, idcathedra, idmetacourse):
        conn = current_app.ms.db(self.lname).connect()

        sql = """
            SELECT distinct clm.idcurriculum,clm.cname 
            FROM curriculum clm 
            INNER JOIN StudyYears2curriculum sy2c ON (sy2c.idcurriculum = clm.idcurriculum and sy2c.syid in (select syid from StudyYears where school_year = :xp_key or :xp_key = 0)) 
            INNER JOIN (
                SELECT idcurriculum FROM curriculum_detail cd 
                JOIN courses crs ON crs.cid=cd.cid 
                WHERE 1=1 AND (crs.meta_course=:idmetacourse OR :idmetacourse=0) AND (:idcathedra=0 OR crs.meta_course IN (SELECT meta_course FROM l_mcourse_cathedra WHERE idcathedra=:idcathedra))
                GROUP BY cd.idcurriculum
            ) d ON clm.idcurriculum=d.idcurriculum 
            ORDER BY clm.cname 
        """

        stmt = text(sql)
        stmt = stmt.bindparams(xp_key=xp_key, idcathedra=idcathedra, idmetacourse=idmetacourse)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
