from typing import Union

from flask import current_app
from decimal import Decimal
from sqlalchemy import text


class Demands:
    @staticmethod
    def get_all_demands(lname: str) -> Union[bool, list]:
        sql = """
            SELECT *, st_time_budget::float FROM qualif_demands
        """
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_curr_demands(lname: str, demand_id: int) -> Union[bool, list]:
        sql = """SELECT *, intensity_unit_hrs::float FROM curriculum 
            WHERE q_demand_id={demand_id}""".format(demand_id=demand_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def get_both_demands(lname: str, demand_id: int) -> Union[bool, list]:
        sql = """SELECT qualif_demands.*, qualif_demands.st_time_budget::float,
                    row_to_json(curriculum.*) curr
                FROM qualif_demands  
                    JOIN curriculum ON qualif_demands.q_demand_id = curriculum.q_demand_id
                WHERE qualif_demands.q_demand_id={demand_id}""".format(demand_id=demand_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def add_demands(lname, data):

        """Из-за особенностей алхимии и того, что она не коммитит одну транзакцию c несколькими действиями,
         пришлось разбить все на большое кол-во запросов"""

        # ADD MAIN DEMAND

        sql = """
            INSERT INTO qualif_demands(mpid, d_date, st_time_budget, file_name, d_num,
                                        kt_project_id, intensity_unit_hrs)
            VALUES({mpid}, now(), {st_time_budget}, '{file_name}', '{d_num}',
                    {kt_project_id}, {intensity_unit_hrs}) 
            RETURNING *
            """.format(mpid=data.get("mpid"), st_time_budget=data.get("st_time_budget") or "null",
                       file_name=data.get("file_name"), d_num=data.get("d_num") or "null",
                       kt_project_id=data.get("kt_project_id") or "null",
                       intensity_unit_hrs=data.get("intensity_unit_hrs") or "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(sql)

        main_demand = query.first()

        if not main_demand:
            return False

        main_demand = dict(main_demand)

        # DISCIPLINES FOR MAIN

        all_disciplines = None

        if data.get("disciplines"):
            values = ""
            for i, disc in enumerate(data.get("disciplines")):
                values += """({q_demand_id}, {cid}, {dis_group_id}, {dis_cycle_id}, {labour_intensity},
                    {compet_code_id}, {hours})""" \
                    .format(q_demand_id=main_demand.get("q_demand_id"), cid=disc.get("cid") or "null",
                            dis_group_id=disc.get("dis_group_id") or "null",
                            dis_cycle_id=disc.get("dis_cycle_id") or "null",
                            labour_intensity=disc.get("labour_intensity") or "null",
                            compet_code_id=disc.get("compet_code_id") or "null", hours=disc.get("hours") or "null")
                if i < len(data.get("disciplines")) - 1:
                    values += ", "

            sql = """
                INSERT INTO q_demand_disciplines(q_demand_id, cid, dis_group_id, dis_cycle_id, labour_intensity,
                    compet_code_id, hours)
                VALUES {values} RETURNING *
            """.format(values=values)

            conn = current_app.ms.db(lname).connect()
            query = conn.execute(sql)

            all_disciplines = query.fetchall()

            if not all_disciplines:
                return False

            all_disciplines = [dict(item) for item in all_disciplines]

        # ADD CURR DEMAND

        sql = """
            INSERT INTO curriculum (cname, q_demand_id, intensity_unit_hrs, agree_post, agree_rank,
                                    agree_fio, confirm_post, confirm_mid, agree_date, confirm_date, open_date,
                                    close_date, confirm_post_text, confirm_rank, confirm_fio, approve_place,
                                    approve_date, approve_num, sign_date, sign_mid, print_view, print_page_cert,
                                    print_page_tsu, print_page_mil, lazarus_version)
            VALUES ('{cname}', {q_demand_id}, {intensity_unit_hrs_2}, {agree_post}, {agree_rank},
                {agree_fio}, {confirm_post}, {confirm_mid}, '{agree_date}', '{confirm_date}', '{open_date}',
                '{close_date}', {confirm_post_text}, {confirm_rank}, {confirm_fio}, {approve_place},
                '{approve_date}', {approve_num}, '{sign_date}', {sign_mid}, {print_view}, {print_page_cert},
                {print_page_tsu}, {print_page_mil}, {lazarus_version})
            RETURNING *
        """.format(
            cname=data.get("curr").get("cname"),
            q_demand_id=main_demand.get("q_demand_id"),
            intensity_unit_hrs_2=data.get("curr").get("intensity_unit_hrs"),
            agree_post="'{}'".format(data.get("curr").get("agree_post"))
                if data.get("curr").get("agree_post") else "null",
            agree_rank="'{}'".format(data.get("curr").get("agree_rank"))
                if data.get("curr").get("agree_rank") else "null",
            agree_fio="'{}'".format(data.get("curr").get("agree_fio"))
                if data.get("curr").get("agree_fio") else "null",
            confirm_post=data.get("curr").get("confirm_post") or "null",
            confirm_mid=data.get("curr").get("confirm_mid") or "null",
            agree_date=data.get("curr").get("agree_date") or "null",
            confirm_date=data.get("curr").get("confirm_date") or "null",
            open_date=data.get("curr").get("open_date") or "null",
            close_date=data.get("curr").get("close_date") or "null",
            confirm_post_text="'{}'".format(data.get("curr").get("confirm_post_text"))
                if data.get("curr").get("confirm_post_text") else "null",
            confirm_rank="'{}'".format(data.get("curr").get("confirm_rank"))
                if data.get("curr").get("confirm_rank") else "null",
            confirm_fio="'{}'".format(data.get("curr").get("confirm_fio"))
                if data.get("curr").get("confirm_fio") else "null",
            approve_place="'{}'".format(data.get("curr").get("approve_place"))
                if data.get("curr").get("approve_place") else "null",
            approve_date=data.get("curr").get("approve_date") or "null",
            approve_num="'{}'".format(data.get("curr").get("approve_num"))
                if data.get("curr").get("approve_num") else "null",
            sign_date=data.get("curr").get("sign_date") or "null",
            sign_mid=data.get("curr").get("sign_mid") or "null",
            print_view=data.get("curr").get("print_view") or "null",
            print_page_cert=data.get("curr").get("print_page_cert") or "null",
            print_page_tsu=data.get("curr").get("print_page_tsu") or "null",
            print_page_mil=data.get("curr").get("print_page_mil") or "null",
            lazarus_version=data.get("curr").get("lazarus_version") or "null"
        )

        conn = current_app.ms.db(lname).connect()
        query = conn.execute(sql)

        curr_demand = query.first()

        if not curr_demand:
            return False

        curr_demand = dict(curr_demand)

        # DISCIPLINES FOR CURRICULUM
        all_curr_disciplines = None

        if data.get("curr").get("disciplines"):
            values = ""
            for i, disc in enumerate(data.get("curr").get("disciplines")):
                values += """({cid}, {with_lecturer}, {lecturing}, {seminar}, {laboratory_works},
                            {practical_training}, {group_exercises}, {group_classes}, {tactical_exercises}, {war_games},
                            {course_work}, {ind_with_lecturer}, {test}, {idcurriculum}, {fin_exam}, 
                            {fin_test}, {fin_test_with_grade}, {control_work}, '{umk_desc}', 
                            {fin_test_work}, {interm_test}, {c_edcycle}, {session_volume}, 
                            {off_session_tests}, {dont_count_in_schedulemaxnum_checks})""" \
                    .format(cid=disc.get("cid"), with_lecturer=disc.get("with_lecturer") or "null",
                            lecturing=disc.get("lecturing") or "null", seminar=disc.get("seminar") or "null",
                            laboratory_works=disc.get("laboratory_works") or "null",
                            practical_training=disc.get("practical_training") or "null",
                            group_exercises=disc.get("group_exercises") or "null",
                            group_classes=disc.get("group_classes") or "null",
                            tactical_exercises=disc.get("tactical_exercises") or "null",
                            war_games=disc.get("war_games") or "null", course_work=disc.get("course_work") or "null",
                            ind_with_lecturer=disc.get("ind_with_lecturer") or "null",
                            test=disc.get("test") or "null", idcurriculum=curr_demand.get("idcurriculum"),
                            fin_exam="ARRAY{}".format(disc.get("fin_exam")) if disc.get("fin_exam") else "null",
                            fin_test="ARRAY{}".format(disc.get("fin_test")) if disc.get("fin_test") else "null",
                            fin_test_with_grade="ARRAY{}".format(disc.get("fin_test_with_grade"))
                                if disc.get("fin_test_with_grade") else "null",
                            control_work=disc.get("control_work") or "null", umk_desc=disc.get("umk_desc") or "null",
                            fin_test_work="ARRAY{}".format(disc.get("fin_test_work"))
                                if disc.get("fin_test_work") else "null",
                            interm_test=disc.get("interm_test") or "null", c_edcycle=disc.get("c_edcycle") or "null",
                            session_volume=disc.get("session_volume") or "null",
                            off_session_tests=disc.get("off_session_tests") or "null",
                            dont_count_in_schedulemaxnum_checks=disc.get(
                                "dont_count_in_schedulemaxnum_checks") or "false")

                if i < len(data.get("curr").get("disciplines")) - 1:
                    values += ", "

            sql = """
                        INSERT INTO curriculum_detail(cid, with_lecturer, lecturing, seminar, laboratory_works,
                            practical_training, group_exercises, group_classes, tactical_exercises, war_games,
                            course_work, ind_with_lecturer, test, idcurriculum, fin_exam, fin_test,
                            fin_test_with_grade, control_work, umk_desc, fin_test_work, interm_test, c_edcycle,
                            session_volume, off_session_tests, dont_count_in_schedulemaxnum_checks)
                        VALUES {values} RETURNING *
                    """.format(values=values)

            conn = current_app.ms.db(lname).connect()
            query = conn.execute(sql)

            all_curr_disciplines = query.fetchall()

            if not all_curr_disciplines:
                return False

            all_curr_disciplines = [dict(item) for item in all_curr_disciplines]

        # SELECT ALL DATA

        sql = """
            SELECT qualif_demands.*, qualif_demands.st_time_budget::float, row_to_json(
                curriculum.*
            ) as curr
            FROM qualif_demands  
                JOIN curriculum ON qualif_demands.q_demand_id = curriculum.q_demand_id
            WHERE qualif_demands.q_demand_id={demand_id}
        """.format(demand_id=main_demand.get("q_demand_id"), idcurriculum=curr_demand.get("idcurruculum"))

        conn = current_app.ms.db(lname).connect()
        query = conn.execute(sql)
        result = query.first()
        if not result:
            return False

        result = dict(result)
        if all_disciplines:
            for disc in all_disciplines:
                for k, v in disc.items():
                    if isinstance(v, Decimal):
                        disc[k] = float(v)
            result["disciplines"] = all_disciplines
        if all_curr_disciplines:
            for disc in all_curr_disciplines:
                for k, v in disc.items():
                    if isinstance(v, Decimal):
                        disc[k] = float(v)
            result["curr"]["disciplines"] = all_curr_disciplines

        return result
