from typing import Union, List, Dict, Any

from flask import current_app, g
from sqlalchemy import text


class DisciplinesCourses:

    @staticmethod
    def create_course(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
            INSERT INTO meta_course(name, shortname, comment, sort_order, education_profile, "InEntranceExamUse",
            status, code, reportname)
            VALUES('{name}', '{shortname}', '{comment}', {sort_order}, {education_profile},
            {InEntranceExamUse}, {status}, {code}, {reportname}) RETURNING *;
        """.format(name=data.get("name"), shortname=data.get("shortname"), comment=data.get("comment"),
                   sort_order=data.get("sort_order") or 0, education_profile=data.get("education_profile") or 0,
                   InEntranceExamUse=data.get("InEntranceExamUse") or 0, status=data.get("status") or 0,
                   code=data.get("code") or "''", reportname=data.get("reportname") or "''")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_courses(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += "('{name}', '{shortname}', '{comment}', {sort_order}, {education_profile},\
            {InEntranceExamUse}, {status}, {code}, {reportname})" \
                .format(name=data.get("name"), shortname=data.get("shortname"), comment=data.get("comment"),
                        sort_order=data.get("sort_order") or 0, education_profile=data.get("education_profile") or 0,
                        InEntranceExamUse=data.get("InEntranceExamUse") or 0, status=data.get("status") or 0,
                        code=data.get("code") or "''", reportname=data.get("reportname") or "''")
            if data != data_list[-1]:
                values += ", "

        sql = """
                INSERT INTO meta_course(name, shortname, comment, sort_order, education_profile, "InEntranceExamUse",
                status, code, reportname)
                VALUES {values} RETURNING *
                """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_discipline_course(lname: str, course_id: int) -> Union[bool, dict]:
        sql = """
                SELECT * FROM meta_course
                WHERE id={course_id}""".format(course_id=course_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_disciplines_many_courses(lname: str, limit: int, offset: int) -> Union[bool, list]:
        limit_offset = ""
        if limit and offset:
            limit_offset = "LIMIT {limit} OFFSET {offset}".format(limit=limit, offset=offset)
        sql = """SELECT * FROM meta_course ORDER BY id {limit_offset}""".format(limit_offset=limit_offset)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def get_disciplines_by_cathedra(lname: str, idcathedra: int) -> Union[bool, list]:
        sql = """
            select distinct *
            from (
                select mc.id, mc.name
                from l_mcourse_cathedra mcc
                join meta_course mc on mcc.meta_course = mc.id
                where mcc.idcathedra = :idcathedra
            
                union
            
                select mc.id, mc.name
                from course2cathedra cc
                join courses c on cc.cid = c.cid
                join meta_course mc on c.meta_course = mc.id
                where cc.cathedraid = :idcathedra
            ) as mc
        """
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql), {"idcathedra": idcathedra})
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_discipline_course_meta(lname: str, course_id: int, data: dict) -> Union[bool, dict]:
        sql = """
                    UPDATE meta_course SET name='name', shortname='shortname', comment='comment',
                    sort_order={sort_order}, education_profile={education_profile},
                    "InEntranceExamUse"={InEntranceExamUse}, status={status}, code={code}, reportname={reportname}
                    WHERE id={course_id} RETURNING *""" \
            .format(name=data.get("name"), shortname=data.get("shortname"), comment=data.get("comment"),
                    sort_order=data.get("sort_order") or 0, education_profile=data.get("education_profile") or 0,
                    InEntranceExamUse=data.get("InEntranceExamUse") or 0, status=data.get("status") or 0,
                    code=data.get("code") or "''", reportname=data.get("reportname") or "''", course_id=course_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    # for rpd courses

    @staticmethod
    def create_rpd_course(lname: str, data: dict) -> Union[bool, dict]:
        sql = """
                INSERT INTO courses(title, description, createby, createdate, alias, xp_split,
                xp_paired, xp_sort, isindividual, isparallelcourse, _idcathedra, dis_group_id,
                course_index, status, "EducationProfile", "InEntranceExamUse", "EntranceExamYear",
                "EntranceExamPreparationStructure", "EntranceExamTrainingDirection",
                "EntranceExamMilitaryProfession", before_exam_space, before_test_space, meta_course,
                c_edcycle, m_group)
                VALUES('{title}', '{description}', '{createby}', now(), '{alias}', '{xp_split}',
                {xp_paired}, {xp_sort}, {isindividual}, {isparallelcourse}, {_idcathedra}, {dis_group_id},
                {course_index}, {status}, {EducationProfile}, {InEntranceExamUse}, {EntranceExamYear},
                {EntranceExamPreparationStructure}, {EntranceExamTrainingDirection},
                {EntranceExamMilitaryProfession}, {before_exam_space}, {before_test_space}, {meta_course},
                {c_edcycle}, '{m_group}') RETURNING *;
            """.format(title=data.get("title"), description=data.get("description"), createby=g.user.id,
                       alias=data.get("alias"), xp_split=data.get("xp_split") or "",
                       xp_paired=data.get("xp_paired") or 0, xp_sort=data.get("xp_sort") or 0,
                       isindividual=data.get("isindividual") or 0, isparallelcourse=data.get("isparallelcourse") or 0,
                       _idcathedra=data.get("idcathedra"), dis_group_id=data.get("dis_group_id") or "null",
                       course_index=data.get("course_index") or "null", status=data.get("status") or 0,
                       EducationProfile=data.get("education_profile") or "null",
                       InEntranceExamUse=data.get("in_entrance_exam_use") or 0,
                       EntranceExamYear=data.get("entrance_exam_year") or "null",
                       EntranceExamPreparationStructure=data.get("entrance_exam_preparation_structure") or "null",
                       EntranceExamTrainingDirection=data.get("entrance_exam_training_direction") or "null",
                       EntranceExamMilitaryProfession=data.get("entrance_exam_military_profession") or "null",
                       before_exam_space=data.get("before_exam_space") or "null",
                       before_test_space=data.get("before_test_space") or "null",
                       meta_course=data.get("meta_course") or "null", c_edcycle=data.get("c_edcycle") or "null",
                       m_group=data.get("m_group") or "null")
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return dict(query.first())

    @staticmethod
    def create_many_rpd_courses(lname: str, data_list: list) -> Union[bool, list]:
        values = ""
        for data in data_list:
            values += "('{title}', '{description}', '{createby}', now(), '{alias}', '{xp_split}',\
                {xp_paired}, {xp_sort}, {isindividual}, {isparallelcourse}, {_idcathedra}, {dis_group_id},\
                {course_index}, {status}, {EducationProfile}, {InEntranceExamUse}, {EntranceExamYear},\
                {EntranceExamPreparationStructure}, {EntranceExamTrainingDirection},\
                {EntranceExamMilitaryProfession}, {before_exam_space}, {before_test_space}, {meta_course},\
                {c_edcycle}, '{m_group}')" \
                .format(title=data.get("title"), description=data.get("description"), createby=g.user.id,
                        alias=data.get("alias"), xp_split=data.get("xp_split") or "",
                        xp_paired=data.get("xp_paired") or 0, xp_sort=data.get("xp_sort") or 0,
                        isindividual=data.get("isindividual") or 0, isparallelcourse=data.get("isparallelcourse") or 0,
                        _idcathedra=data.get("idcathedra"), dis_group_id=data.get("dis_group_id") or "null",
                        course_index=data.get("course_index") or "null", status=data.get("status") or 0,
                        EducationProfile=data.get("education_profile") or "null",
                        InEntranceExamUse=data.get("in_entrance_exam_use") or 0,
                        EntranceExamYear=data.get("entrance_exam_year") or "null",
                        EntranceExamPreparationStructure=data.get("entrance_exam_preparation_structure") or "null",
                        EntranceExamTrainingDirection=data.get("entrance_exam_training_direction") or "null",
                        EntranceExamMilitaryProfession=data.get("entrance_exam_military_profession") or "null",
                        before_exam_space=data.get("before_exam_space") or "null",
                        before_test_space=data.get("before_test_space") or "null",
                        meta_course=data.get("meta_course") or "null", c_edcycle=data.get("c_edcycle") or "null",
                        m_group=data.get("m_group") or "null")
            if data != data_list[-1]:
                values += ", "

        sql = """
                INSERT INTO courses(title, description, createby, createdate, alias, xp_split,
                    xp_paired, xp_sort, isindividual, isparallelcourse, _idcathedra, dis_group_id,
                    course_index, status, "EducationProfile", "InEntranceExamUse", "EntranceExamYear",
                    "EntranceExamPreparationStructure", "EntranceExamTrainingDirection",
                    "EntranceExamMilitaryProfession", before_exam_space, before_test_space, meta_course,
                    c_edcycle, m_group)
                VALUES {values} RETURNING *
                    """.format(values=values)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        return [dict(group) for group in query.fetchall()]

    @staticmethod
    def get_discipline_rpd_course(lname: str, course_id: int) -> Union[bool, dict]:
        sql = """
                    SELECT * FROM courses
                    WHERE cid={course_id}""".format(course_id=course_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)

    @staticmethod
    def get_disciplines_many_rpd_courses(lname: str, limit: int, offset: int) -> Union[bool, list]:
        limit_offset = ""
        if limit and offset:
            limit_offset = "LIMIT {limit} OFFSET {offset}".format(limit=limit, offset=offset)
        sql = """SELECT * FROM courses ORDER BY cid {limit_offset}""".format(limit_offset=limit_offset)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.fetchall()
        if not res:
            return False
        return [dict(group) for group in res]

    @staticmethod
    def update_discipline_course(lname: str, course_id: int, data: dict) -> Union[bool, dict]:
        sql = """
                UPDATE courses SET title='{title}', description='{description}',
                    createdate=now(), alias='{alias}', xp_split='{xp_split}',
                    xp_paired={xp_paired}, xp_sort={xp_sort}, isindividual={isindividual},
                    isparallelcourse={isparallelcourse}, _idcathedra={_idcathedra}, dis_group_id={dis_group_id},
                    course_index={course_index}, status={status}, "EducationProfile"={EducationProfile},
                    "InEntranceExamUse"={InEntranceExamUse}, "EntranceExamYear"={EntranceExamYear},
                    "EntranceExamPreparationStructure"={EntranceExamPreparationStructure},
                    "EntranceExamTrainingDirection"={EntranceExamTrainingDirection},
                    "EntranceExamMilitaryProfession"={EntranceExamMilitaryProfession},
                    before_exam_space={before_exam_space}, before_test_space={before_test_space},
                    meta_course={meta_course}, c_edcycle={c_edcycle}, m_group='{m_group}'
                WHERE cid={course_id} RETURNING *""" \
            .format(title=data.get("title"), description=data.get("description"),
                    alias=data.get("alias"), xp_split=data.get("xp_split") or "",
                    xp_paired=data.get("xp_paired") or 0, xp_sort=data.get("xp_sort") or 0,
                    isindividual=data.get("isindividual") or 0, isparallelcourse=data.get("isparallelcourse") or 0,
                    _idcathedra=data.get("idcathedra"), dis_group_id=data.get("dis_group_id") or "null",
                    course_index=data.get("course_index") or "null", status=data.get("status") or 0,
                    EducationProfile=data.get("education_profile") or "null",
                    InEntranceExamUse=data.get("in_entrance_exam_use") or 0,
                    EntranceExamYear=data.get("entrance_exam_year") or "null",
                    EntranceExamPreparationStructure=data.get("entrance_exam_preparation_structure") or "null",
                    EntranceExamTrainingDirection=data.get("entrance_exam_training_direction") or "null",
                    EntranceExamMilitaryProfession=data.get("entrance_exam_military_profession") or "null",
                    before_exam_space=data.get("before_exam_space") or "null",
                    before_test_space=data.get("before_test_space") or "null",
                    meta_course=data.get("meta_course") or "null", c_edcycle=data.get("c_edcycle") or "null",
                    m_group=data.get("m_group") or "null", course_id=course_id)
        conn = current_app.ms.db(lname).connect()
        query = conn.execute(text(sql))
        res = query.first()
        if not res:
            return False
        return dict(res)
