# coding=UTF-8
# LMSAPI/API/Journal.py
from decimal import Decimal

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app, g
import pickle

from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.Term import Term
from LMSAPI.api.Models.User import User


class Journal:
    def getfromredis(self, lname, termid, onedate, courseid, groupid, iscontrol):
        cName = (
            "JOURNALDETAIL"
            + str(termid)
            + "-"
            + str(onedate)
            + "-"
            + str(courseid)
            + "-"
            + str(groupid)
            + "-"
            + str(iscontrol)
        )
        cachedDetail = current_app.ms.redis(lname).get(cName)
        if cachedDetail is not None:
            # current_app.logger.debug('UMKCourse from cache '+ str(id))
            detail = pickle.loads(cachedDetail)
            return detail
        # current_app.logger.debug("Cache miss " + cName)
        return

    def settoredis(self, lname, termid, onedate, courseid, groupid, iscontrol, data):
        cName = (
            "JOURNALDETAIL"
            + str(termid)
            + "-"
            + str(onedate)
            + "-"
            + str(courseid)
            + "-"
            + str(groupid)
            + "-"
            + str(iscontrol)
        )
        current_app.ms.redis(lname).setex(cName, 120, pickle.dumps(data))
        # current_app.logger.debug("Set cache " + cName)
        return

    def checkGrade(self, lname, grade):
        conn = current_app.ms.db(lname).connect()

        #        valid = False

        #        sql = "select * from schedule_grades_values where value = :grade"
        #        stmt = text(sql)
        #        stmt = stmt.bindparams(grade=grade)
        #
        #        query = conn.execute(stmt)

        #        for row in query:
        #            valid = True

        #        if valid == False:
        #            return False

        sql = "select CheckGrades( :grade)"
        stmt = text(sql)
        stmt = stmt.bindparams(grade=grade)

        query = conn.execute(stmt)

        for row in query:
            if row.checkgrades == 1:
                return True

        return False

    def setGrade(self, lname, sheid, week_id, grade, mid, teacher_mid, comment = ''):
        conn = current_app.ms.db(lname).connect()
        User(lname).prepare_logger(conn)
        sql = "select * from xp_upsave_journal_grade(:sheid, :week_id, :grade, null, :mid, :teacher_mid, :comment, :none); commit;"

        stmt = text(sql)
        stmt = stmt.bindparams(sheid=sheid)
        stmt = stmt.bindparams(week_id=week_id)
        stmt = stmt.bindparams(grade=str(grade))
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(none=0)
        stmt = stmt.bindparams(teacher_mid=teacher_mid)
        stmt = stmt.bindparams(comment=comment)
        conn.execute(stmt)

    def get_grades_by_sheid_week_mid(self, lname, sheid, week_id, mid):
        conn = current_app.ms.db(lname).connect()

        sql = """      
            select * from nnz_sh_grades where sheid = :sheid and week_id = :week_id and student_mid = :mid
            """

        stmt = text(sql)
        stmt = stmt.bindparams(sheid=sheid, week_id=week_id, mid=mid)
        query = conn.execute(stmt)
        result = query.fetchone()

        return result

    def setTermGrade(self, lname, trmid, cid, grade, mid, teacher_mid):
        conn = current_app.ms.db(lname).connect()

        # valid = False
        #
        # sql = "select * from xp_upsave_term_grades(:trmid, :trmtid, :cid, :grade, :mid, :teacher_mid, '', :none); commit;"
        # stmt = text(sql)
        # stmt = stmt.bindparams(grade=grade)
        #
        # query = conn.execute(stmt)
        #
        # User(lname).prepare_logger(conn)
        sql = "select * from xp_upsave_term_grades(:trmid, :trmtid, :cid, :grade, :mid, :teacher_mid, null, '', :none); commit;"

        stmt = text(sql)
        stmt = stmt.bindparams(trmid=trmid)
        stmt = stmt.bindparams(trmtid=11)
        stmt = stmt.bindparams(cid=cid)
        stmt = stmt.bindparams(grade=str(grade))
        stmt = stmt.bindparams(mid=mid)
        stmt = stmt.bindparams(teacher_mid=teacher_mid)
        stmt = stmt.bindparams(none=0)
        conn.execute(stmt)

    def getJournal(
        self,
        lname,
        termid,
        onedate,
        courseid,
        groupid,
        iscontrol,
        security,
        open_lesson,
        their_lesson,
    ):
        if termid is not 0:
            onedate = None

        conn = current_app.ms.db(lname).connect()

        filters, where = get_filters(security, open_lesson, their_lesson)

        sql = """SELECT  nnz_fill_journal_u46 (:termid,:onedate,:courseid,:groupid,:iscontrol);

        INSERT INTO journal (mid, "lessonfulldate", lessondate, LessonUnixDate,  student, instance, sheid, LessonID)
         SELECT 99999, journal."lessonfulldate", lessondate, LessonUnixDate,  'Ср. балл', instance, journal.sheid, journal.LessonID
         FROM journal
         LEFT OUTER JOIN (
          SELECT journal."lessonfulldate", sheid, mid, LessonID
          FROM journal
            WHERE mid = 99999  
          GROUP BY journal."lessonfulldate", sheid, mid, LessonID) EEE ON EEE."lessonfulldate" = journal."lessonfulldate" AND EEE.sheid = journal.sheid
         WHERE journal.mid = 9999999 and EEE."lessonfulldate" IS NULL 
         GROUP BY journal."lessonfulldate", lessondate, LessonUnixDate,  instance, journal.sheid, journal.LessonID
         ORDER BY LessonUnixDate;
        
         INSERT INTO journal (mid, "lessonfulldate", lessondate, LessonUnixDate,  student, instance, sheid, LessonID)
         SELECT 999999, journal."lessonfulldate", lessondate, LessonUnixDate,  'Кол-во оценок', instance, journal.sheid, journal.LessonID
         FROM journal
         LEFT OUTER JOIN (
          SELECT journal."lessonfulldate", sheid, mid, journal.LessonID
          FROM journal
            WHERE mid = 999999  
          GROUP BY journal."lessonfulldate", sheid, mid, LessonID) EEE ON EEE."lessonfulldate" = journal."lessonfulldate" AND EEE.sheid = journal.sheid
         WHERE journal.mid = 9999999 and EEE."lessonfulldate" IS NULL 
         GROUP BY journal."lessonfulldate", lessondate, LessonUnixDate,  instance, journal.sheid, journal.LessonID
         ORDER BY LessonUnixDate;
        
         {filters}
         
         SELECT 
         journal.mid,journal.module_id, journal."sheid", journal."instance",  journal."lessondate", journal."lessonid", journal."student", journal."lessonfulldate", journal."lessonunixdate",  journal."gradecomment", 
         journal."lessonactivity", journal."grademid", journal."gradedate",  journal."lessontypeid", journal."lessontype", journal."lessonshorttype", journal."otitle", journal."lessontitleid", journal.hwid, journal."studenthomework", journal."lessonhomework", 
         journal."lessonworkcount", journal."gid", journal."grade",  journal."changemid", journal."changeteacher", journal."changecid", journal."changecourse", journal."changedel", journal."changecomments",  
         journal."holidayname", journal."holidaychangedate", journal."part", journal."classname",  journal."in_out", journal."transfer_date", journal."transfer_cause", journal."st_state_id", journal."rfidid", kurs.year as kurs,  case 
          when 2 = any(TeacherMid) then 1   else 0
          end teacher_edit, 
          case     when ChangeComments <> '' then 1    else 0  end  isChangeComments,  case     when holidayname <> '' and HolidayChangeDate = '' then 1    else 0  end  isholiday_with_nocarry,  case     when holidayname <> '' and HolidayChangeDate <> '' then 1    else 0  end  isholiday_with_carry,  case     when in_out <> '' then 1    else 0  end  isout,
          et.processtypeid,
          journal.LessonHomeWork, t.employer
         FROM journal
         LEFT OUTER JOIN eventtools et on et.typeid = journal.LessonTypeID
         LEFT JOIN groupname g on g.gid = journal.gid
         LEFT JOIN vw_teachers t on g.class_teacher = journal.mid
         LEFT JOIN (
            SELECT gid, year FROM group_history gh
            WHERE gh.school_year = (
                SELECT year FROM terms
                WHERE trmid = :termid
            ) AND gh.gid = :groupid
        ) kurs ON journal.gid = kurs.gid
         {where}
         ORDER BY (case when journal.mid = 99999 then 3 when journal.mid = 999999 then 2 when journal.mid = 9999999 then 1 else 0 END), LessonUnixDate, Student, LessonID;
        """.format(
            where=where,
            filters=filters,
        )

        stmt = text(sql)

        stmt = stmt.bindparams(termid=termid)
        stmt = stmt.bindparams(onedate=onedate)
        stmt = stmt.bindparams(groupid=groupid)
        stmt = stmt.bindparams(iscontrol=iscontrol)
        stmt = stmt.bindparams(courseid=courseid)
        stmt = stmt.bindparams(iscontrol=iscontrol)
        query = conn.execute(stmt)

        journal = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        for r in journal:
            r["indHWFiles"] = File(lname).getHomeworkFiles(
                r["mid"], r["sheid"], r["instance"]
            )
            r["indHWResultFiles"] = File(lname).getHomeworkResultFiles(
                r["mid"], r["sheid"], r["instance"]
            )
            r["commonHWResultFiles"] = File(lname).getGroupHomeworkResultFiles(
                r["mid"], r["sheid"], r["instance"]
            )
        return {"journal": journal}

    def getJournalRashod(self, lname, onedate, groupid):
        conn = current_app.ms.db(lname).connect()
        sql = """
            select xp_fill_groupuser_period(:onedate, :onedate, :groupid);
    
            SELECT 
             vs.sheid, vs.week_id,
             people.mid, people.Lastname, people.FirstName, people.Patronymic,
             military_rank.title militaryrank,
             p.lid periodid,
             p.short_name periodname,
             grade.grade as grade
             FROM vw_schedule vs
             INNER JOIN nnz_schedule s ON s.sheid = vs.sheid
             INNER JOIN groupuser_period gu ON gu.gid = s.gid
             INNER JOIN people ON gu.mid = people.mid
             LEFT OUTER JOIN xp_personal_file pf on people.mid = pf.mid
                    LEFT OUTER JOIN military_rank on military_rank.id_mil_rank = pf."MilitaryRank"
             LEFT OUTER JOIN nnz_sh_grades grade 
               LEFT OUTER JOIN  schedule_grades_values 
               ON grade.grade = schedule_grades_values.value
             ON grade.sheid = s.sheid AND grade.week_id = vs.week_id AND grade.student_mid = people.mid  AND schedule_grades_values.absent_sign <> 0
             INNER JOIN periods p ON p.lid = s.period
             join group_history gh on  gh.school_year = vs.school_year and gu.gid = gh.gid 
             WHERE s.gid = :groupid AND :onedate = vs.lesson_date -- between nnz_weeks.wstart_date and nnz_weeks.wend_date 
                ORDER BY p.starttime;
		"""

        stmt = text(sql)
        stmt = stmt.bindparams(onedate=onedate)
        stmt = stmt.bindparams(groupid=groupid)
        query = conn.execute(stmt)

        journal = {
            "journal_rashod": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        return journal

    def get_number_and_name_of_the_section_and_topic_one(self, lname, sheid, module_id):
        conn = current_app.ms.db(lname).connect()

        sql = """
            select o.oid,concat_ws(' ',o.title_index,o.title) as title from organizations o 
            where o.oid in ( select o.oid 
            from organizations o 
            join nnz_schedule s on s.cid=o.cid 
            join nnz_weeks w on w.sh_var_id=s.sh_var_id 
            join term_weeks tw on tw.week_id=w.week_id 
             join terms t on t.trmid=tw.trmid 
            join nnz_schedule_variants v on v.sh_var_id=s.sh_var_id 
            join groupname g on g.gid=s.gid 
            left join groupname g2 on g2.gid=g.owner_gid 
            join groupname g3 on g3.gid=coalesce(g2.gid,g.gid) 
            join group_history gh on gh.gid=g3.gid and gh.school_year=v.s_year_id 
            join educationyears ey on ey."number"=gh.year 
            join termslist tl on tl.eyid=ey.eyid and tl.tlid=o.termlist_id and tl."number"::integer = 2*(ey."number"-1) + 1 +
             (select count('#42') from terms tb where tb.year=t.year and to_date(tb.term_end,'dd.mm.yyyy')<=to_date(t.term_begin,'dd.mm.yyyy')) 
            join qualif_demands q on q.mpid=g3.f_militaryprofession 
            join curriculum clm on clm.q_demand_id=q.q_demand_id 
            join studyyears2curriculum s2c on s2c.idcurriculum=clm.idcurriculum and s2c.syid=g3.syid 
            join curriculum_detail cd on cd.idcurriculum=clm.idcurriculum and cd.cid=o.cid 
            join curriculum_course cc on cd.id_curr_detail=any(cc.id_curr_details || cc.id_curr_detail) 
            join  curriculum_course_details ccd on ccd.id_curriculum_course=cc.id_curriculum_course and ccd.eyid=ey.eyid and ccd.tlid=tl.tlid and ccd.oid=o.oid 
            where s.sheid=:sheid 
            union select :module_id ) 
            order by  2 """

        stmt = text(sql)
        stmt = stmt.bindparams(sheid=sheid)
        stmt = stmt.bindparams(module_id=module_id)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_number_and_name_of_the_section_and_topic_all(self, lname, sheid, module_id):
        conn = current_app.ms.db(lname).connect()

        sql = """
            select o.oid,concat_ws(' ',o.title_index,o.title) as title from organizations o 
            where o.oid in ( select o.oid 
            from organizations o 
            join nnz_schedule s on s.cid=o.cid 
            join nnz_weeks w on w.sh_var_id=s.sh_var_id 
            join term_weeks tw on tw.week_id=w.week_id 
             join terms t on t.trmid=tw.trmid 
            join nnz_schedule_variants v on v.sh_var_id=s.sh_var_id 
            join groupname g on g.gid=s.gid 
            left join groupname g2 on g2.gid=g.owner_gid 
            join groupname g3 on g3.gid=coalesce(g2.gid,g.gid) 
            join group_history gh on gh.gid=g3.gid and gh.school_year=v.s_year_id 
            join educationyears ey on ey."number"=gh.year 
            join termslist tl on tl.eyid=ey.eyid and tl.tlid=o.termlist_id and tl."number"::integer = 2*(ey."number"-1) + 1 + 
            (select count('#42') from terms tb where tb.year=t.year and to_date(tb.term_end,'dd.mm.yyyy')<=to_date(t.term_begin,'dd.mm.yyyy'))
            where s.sheid=:sheid 
            union select :module_id ) 
            order by  2 """

        stmt = text(sql)
        stmt = stmt.bindparams(sheid=sheid)
        stmt = stmt.bindparams(module_id=module_id)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def create_number_and_name_of_the_section_and_topic(self, lname, data_dict):
        conn = current_app.ms.db(lname).connect()

        sql = """ 
            insert into organizations(title_index, title, description, cid, level, prev_ref, module, __teacher_mid, termlist_id) 
            values (:title_index, :title, :description, :cid, :level, :prev_ref, :module, :__teacher_mid, :termlist_id) 
            returning oid 
            """
        stmt = text(sql)
        stmt = stmt.bindparams(
            title_index=data_dict.get("title_index"),
            title=data_dict.get("title"),
            description=data_dict.get("description"),
            cid=data_dict.get("cid"),
            level=data_dict.get("level"),
            prev_ref=data_dict.get("prev_ref"),
            module=data_dict.get("module"),
            __teacher_mid=data_dict.get("__teacher_mid"),
            termlist_id=data_dict.get("termlist_id"),
        )
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def getJournalGradeValues(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """select Value, IsGrade, absent_sign, text, positive_grade from schedule_grades_values order by IsGrade, Value"""

        stmt = text(sql)
        query = conn.execute(stmt)

        journal = {
            "grade_values": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        return journal

    def getJournalAbsentGrades(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT * FROM schedule_grades_values WHERE absent_sign <> 0;"""

        stmt = text(sql)
        query = conn.execute(stmt)

        journal = {
            "absent_grades": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        return journal

    def get_lesson_type_icons(self, lname, lessontypeid):
        conn = current_app.ms.db(lname).connect()

        sql = """select bmp from eventtools where typeid = :lessontypeid"""

        stmt = text(sql)
        stmt = stmt.bindparams(lessontypeid=lessontypeid)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def create_lesson_type_icons(self, lname, lessontypeid: int, image_bytes: bytes):
        conn = current_app.ms.db(lname).connect()

        sql = """
            UPDATE eventtools
            SET bmp = :image_bytes
            WHERE typeid = :lessontypeid
            """

        stmt = text(sql)
        stmt = stmt.bindparams(lessontypeid=lessontypeid)
        stmt = stmt.bindparams(image_bytes=image_bytes)
        conn.execute(stmt)

    def delete_lesson_type_icons(self, lname, lessontypeid: int):
        conn = current_app.ms.db(lname).connect()

        sql = """
            UPDATE eventtools
            SET bmp = 'NULL'::bytea
            WHERE typeid = :lessontypeid
            """

        stmt = text(sql)
        stmt = stmt.bindparams(lessontypeid=lessontypeid)
        conn.execute(stmt)

    def get_tmp_sheid_weeks(
        self,
        lname,
        termid,
        onedate,
        courseid,
        groupid,
        iscontrol,
        security,
        open_lesson,
        their_lesson,
    ):
        if termid is not 0:
            onedate = None

        conn = current_app.ms.db(lname).connect()

        filters, where = get_filters(security, open_lesson, their_lesson)

        sql = """
            SELECT  nnz_fill_journal (:termid,:onedate,:courseid,:groupid,:iscontrol);	
            drop table if exists tmp_sheid_weeks;
            create temporary table tmp_sheid_weeks as
            select distinct sheid, instance as week_id, LessonDate, LessonFullDate, LessonTypeID, LessonTitleID, LessonHomeWork, LessonWorkCount, TeacherMid, gid, LessonID
            from journal where mid <> 99999 and mid <> 999999 and mid <> 9999999 and sheid <> 0 
                and not journal."sheid" in 
                (SELECT sheid from journal j2 
                JOIN eventtools et2 on et2.typeid = j2.LessonTypeID 
                JOIN processes pcs ON pcs.pid = et2.processtypeid 
                WHERE pcs.pid = 3 and pcs.is_exam = 1);
            
            {filters}
            
            select ifnull(f.sh_mod_fact_id, 0) as sh_mod_fact_id, w.LessonFullDate, w.SHEID, w.week_id,
              if(f.sh_mod_fact_id is null, 0, 1) as Passed,
              ifnull(f.event_type, 0) as event_type, e.alias as typename, w.LessonTypeID event_type_J,
              f.module_id, w.LessonTitleID as module_id_J, coalesce(f.tema,ctd.tema,o.title) as FactTheme, w.LessonWorkCount as work_count_J,
              hf.text as hw_text, w.LessonHomeWork as hw_text_J, f.teacher_comments, 
              hf.hwid as homefactid, 
              sm.lesson_number, 
              case when 2 = any(w.TeacherMid) then 1 else 0 end teacher_edit, w.gid as gid_J, hd.name holidayname
            from tmp_sheid_weeks w
            left outer join nnz_sh_module_fact f on w.sheid = f.sheid and w.week_id = f.week_id
            left outer join nnz_schedule_modules sm on w.sheid = sm.sheid and w.week_id = sm.week_id
            left outer join nnz_homework_fact hf on w.sheid = hf.sheid and w.week_id = hf.week_id
            left outer join eventtools e on coalesce(f.event_type,w.LessonTypeID) = e.TypeID
            left outer join organizations o on f.module_id = o.oid
            left outer join holidays hd on hd.date = w.LessonFullDate
            left outer join course_tema_detail ctd on ctd.id = f.course_tema_detail
            {where}
            order by w.LessonFullDate, w.LessonID;
            """.format(
            where=where,
            filters=filters,
        )

        stmt = text(sql)
        stmt = stmt.bindparams(termid=termid)
        stmt = stmt.bindparams(onedate=onedate)
        stmt = stmt.bindparams(groupid=groupid)
        stmt = stmt.bindparams(iscontrol=iscontrol)
        stmt = stmt.bindparams(courseid=courseid)
        query = conn.execute(stmt)

        tmp_sheid_weeks = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return tmp_sheid_weeks

    def post_held_tmp_sheid_weeks(self, lname, data_dict):
        conn = current_app.ms.db(lname).connect()
        trans = conn.begin()

        try:
            if data_dict.get("passed") == 1:
                sql = """ select * from nnz_sh_module_fact WHERE sheid=:sheid and week_id=:week_id """
                stmt = text(sql)
                stmt = stmt.bindparams(
                    sheid=data_dict.get("sheid"), week_id=data_dict.get("week_id")
                )
                query = conn.execute(stmt)
                sh_module_fact = [
                    dict(zip(tuple(query.keys()), i)) for i in query.cursor
                ]

                if (
                    not sh_module_fact.__len__ == 0
                    or sh_module_fact[0]["sh_mod_fact_id"] == 0
                ):
                    sql = """ 
                        INSERT INTO nnz_sh_module_fact( sheid, week_id, event_type, module_type, module_id, 
                            work_count, hw_text,  iscontrol, issecret, lesson_number, 
                            isopen, course_tema_detail, goal, tema, books, equipment, test_equipment, 
                            tema_num, additional_books, official_books, questions, methodical) 
                        SELECT t.sheid, t.week_id, coalesce(m.event_type,ctd.eventtool, s.pair_type_id), module, o.oid, 
                            coalesce(m.work_count,1), coalesce(h.text,ctd.homework), m.iscontrol, m.issecret, 
                            coalesce(m.lesson_number,ctd.num), m.isopen, ctd.id, coalesce(m.goal,ctd.content), 
                            coalesce(m.tema,ctd.tema), coalesce(m.books,ctd.books), coalesce(m.equipment,ctd.equipment), 
                            coalesce(m.test_equipment,ctd.test_equipment), coalesce(m.tema_num,ctd.tema_num), 
                            coalesce(m.additional_books,ctd.additional_books),coalesce(m.official_books,ctd.official_books), 
                            coalesce(m.questions,ctd.questions), coalesce(m.methodical,ctd.methodical) 
                        FROM (select :sheid as sheid, :week_id as week_id) t 
                          JOIN nnz_schedule s ON s.sheid=t.sheid 
                          LEFT JOIN nnz_schedule_modules m ON m.sheid=t.sheid AND m.week_id=t.week_id 
                          LEFT JOIN nnz_homework h ON h.sheid=t.sheid  AND h.week_id=t.week_id 
                          LEFT JOIN course_tema_detail ctd ON ctd.id=coalesce(m.course_tema_detail,s.course_tema_detail_id) 
                          LEFT JOIN organizations o ON o.oid=coalesce(m.module_id,s.f_organizations) 
                        returning sh_mod_fact_id;  
                        """
                    stmt = text(sql)
                    stmt = stmt.bindparams(
                        sheid=data_dict.get("sheid"), week_id=data_dict.get("week_id")
                    )
                    query = conn.execute(stmt)
                    sh_module_fact = [
                        dict(zip(tuple(query.keys()), i)) for i in query.cursor
                    ]

                    sql = """ 
                        INSERT INTO nnz_schedule_modules_parts(isfact,sh_mod_id,num,name,content,questions,part_time,part) 
                        SELECT true, :sh_mod_fact_id, p.num,p.name,p.content,p.questions,p.part_time,p.part 
                        FROM (select :sheid as sheid, :week_id as week_id) t 
                        LEFT JOIN nnz_schedule_modules m ON m.sheid=t.sheid AND m.week_id=t.week_id 
                        LEFT JOIN nnz_schedule_modules_parts p ON p.sh_mod_id=m.sh_mod_id AND NOT coalesce(p.isfact,false);
                        """
                    stmt = text(sql)
                    stmt = stmt.bindparams(
                        sheid=data_dict.get("sheid"),
                        week_id=data_dict.get("week_id"),
                        sh_mod_fact_id=sh_module_fact[0]["sh_mod_fact_id"],
                    )
                    conn.execute(stmt)

                else:
                    sql = """ 
                        DELETE FROM nnz_schedule_modules_parts WHERE isfact AND sh_mod_id=%2:d; 
                        INSERT INTO nnz_schedule_modules_parts(isfact,sh_mod_id, num,name,content,questions,part_time,part) 
                        SELECT true, :sh_mod_fact_id, p.num,p.name,p.content,p.questions,p.part_time,p.part 
                        FROM (select :sheid as sheid, :week_id as week_id) t '+
                          LEFT JOIN nnz_schedule_modules m ON m.sheid=t.sheid AND m.week_id=t.week_id 
                          LEFT JOIN nnz_schedule_modules_parts p ON p.sh_mod_id=m.sh_mod_id AND NOT coalesce(p.isfact,false); 
                        """
                    stmt = text(sql)
                    stmt = stmt.bindparams(
                        sheid=data_dict.get("sheid"),
                        week_id=data_dict.get("week_id"),
                        sh_mod_fact_id=sh_module_fact[0]["sh_mod_fact_id"],
                    )
                    conn.execute(stmt)

                    sql = """ 
                        UPDATE nnz_sh_module_fact f SET 
                         event_type=coalesce(m.event_type,ctd.eventtool, s.pair_type_id), module_id=o.oid, 
                         course_tema_detail=ctd.id, work_count=coalesce(m.work_count,1), iscontrol=m.iscontrol, 
                         issecret=m.issecret,isopen=m.isopen, lesson_number=coalesce(m.lesson_number,ctd.num), 
                         tema_num=coalesce(m.tema_num,ctd.tema_num), hw_text=coalesce(h.text,ctd.homework), 
                         teacher_comments=null, goal=coalesce(m.goal,ctd.content), tema=coalesce(m.tema,ctd.tema), 
                         questions=coalesce(m.questions,ctd.questions), methodical=coalesce(m.methodical,ctd.methodical), 
                         books=coalesce(m.books,ctd.books), 
                         additional_books=coalesce(m.additional_books,ctd.additional_books), 
                         official_books=coalesce(m.official_books,ctd.official_books), 
                         equipment=coalesce(m.equipment,ctd.equipment), 
                         test_equipment=coalesce(m.test_equipment,ctd.test_equipment) 
                        FROM (SELECT :sheid as sheid, :week_id as week_id) t 
                         JOIN nnz_schedule s ON s.sheid=t.sheid 
                          LEFT JOIN nnz_homework h ON h.sheid=t.sheid  AND h.week_id=t.week_id 
                          LEFT JOIN nnz_schedule_modules m ON m.sheid=t.sheid AND m.week_id=t.week_id 
                          LEFT JOIN course_tema_detail ctd ON ctd.id=coalesce(m.course_tema_detail,s.course_tema_detail_id) 
                          LEFT JOIN organizations o ON o.oid=coalesce(m.module_id,s.f_organizations) 
                        WHERE f.sh_mod_fact_id=:sh_mod_fact_id
                        """
                    stmt = text(sql)
                    stmt = stmt.bindparams(
                        sheid=data_dict.get("sheid"),
                        week_id=data_dict.get("week_id"),
                        sh_mod_fact_id=sh_module_fact[0]["sh_mod_fact_id"],
                    )
                    conn.execute(stmt)

            else:
                sql = """ 
                    DELETE FROM nnz_sh_module_fact WHERE sheid=:sheid AND week_id=:week_id
                    """
                stmt = text(sql)
                stmt = stmt.bindparams(
                    sheid=data_dict.get("sheid"),
                    week_id=data_dict.get("week_id"),
                )
                conn.execute(stmt)

                sql = """ 
                    DELETE FROM nnz_homework_fact WHERE sheid=:sheid AND week_id=:week_id
                    """
                stmt = text(sql)
                stmt = stmt.bindparams(
                    sheid=data_dict.get("sheid"),
                    week_id=data_dict.get("week_id"),
                )
                conn.execute(stmt)
            trans.commit()
            return True

        except Exception as e:
            print(e)
            trans.rollback()
            return False

    def get_control_of_class(
        self, lname, idcathedra, courseid, groupid, idfaculty, trmid, onedate
    ):
        conn = current_app.ms.db(lname).connect()

        terms = Term.get_term(lname=lname, trmid=trmid)
        term_begin, term_end = terms[0]["term_begin"], terms[0]["term_end"]

        where = ""
        where += " AND m.checkdate = :onedate" if onedate and trmid == 0 else ""
        where += (
            " and m.checkdate BETWEEN :term_begin AND :term_end" if trmid > 0 else ""
        )
        where += " AND cs.idcathedra = :idcathedra " if idcathedra > 0 else ""
        where += " AND f.idfaculty = :idfaculty " if idfaculty > 0 else ""
        check_group = (
            " AND (g1.gid = :groupid OR g1.owner_gid = :groupid) "
            if groupid > 0
            else ""
        )
        check_course = " AND c.cid = :courseid " if courseid > 0 else ""

        sql = """
            SELECT 
                jmid,
                checkdate,
                g1.name,
                c.title,
                array_to_string(array_agg(pft.mid), ',') AS arr_mids,
                array_to_string(array_agg(concat_ws(' ', mrt.title, xp_f_get_mid_fio(pft.mid, 1))), ', '),
                concat_ws(' ', posi.name, mri.title, xp_f_get_mid_fio(execmid, 1)),
                done,
                checktext,
                xp_f_get_mid_fio(coalesce(familiarize_who, 0), 1),
                familiarize_when
            FROM journal_monitoring m
            JOIN groupname g1 ON g1.gid = m.gid {check_group}
            LEFT JOIN cathedras cs ON cs.idcathedra = g1.idcathedra
            LEFT JOIN faculty f ON f.idfaculty = coalesce(g1.idfaculty, cs.faculty)
            JOIN courses c ON c.cid = m.checkcid {check_course}
            JOIN nnz_schedule sh ON sh.sheid = m.f_sheid
            LEFT JOIN xp_personal_file pft ON pft.mid = ANY(sh.teacher_mid)
            LEFT JOIN military_rank mrt ON mrt.id_mil_rank = pft."MilitaryRank"
            JOIN xp_personal_file pfi ON pfi.mid = execmid
            LEFT JOIN positions posi ON posi.pid = pfi."Position"
            LEFT JOIN military_rank mri ON mri.id_mil_rank = pfi."MilitaryRank"
            WHERE 1=1 {where}
            GROUP BY 
                m.jmid, m.checkdate, m.execmid, m.done, m.checktext, 
                g1.gid, g1.name, 
                c.cid, c.title, 
                posi.pid, posi.name, 
                mri.id_mil_rank, mri.title, familiarize_who, familiarize_when;
        """.format(
            where=where,
            check_group=check_group,
            check_course=check_course,
        )

        stmt = text(sql)
        if groupid > 0:
            stmt = stmt.bindparams(groupid=groupid)
        if courseid > 0:
            stmt = stmt.bindparams(courseid=courseid)
        if idcathedra > 0:
            stmt = stmt.bindparams(idcathedra=idcathedra)
        if idfaculty > 0:
            stmt = stmt.bindparams(idfaculty=idfaculty)
        if trmid > 0:
            stmt = stmt.bindparams(term_begin=term_begin)
            stmt = stmt.bindparams(term_end=term_end)
        else:
            stmt = stmt.bindparams(onedate=onedate)

        query = conn.execute(stmt)

        control_of_class = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return control_of_class

    def get_eventtools(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """
            SELECT TypeID, TypeName FROM eventtools WHERE  IsMain <> 0 ORDER BY TypeName;
        """

        stmt = text(sql)
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_class_topic(self, lname, sheid, week_id):
        conn = current_app.ms.db(lname).connect()

        sql = """
            SELECT 
                z.sh_mod_id, 
                ctd.id AS "course_tema_detail_id", 
                COALESCE(z.event_type, ctd.eventtool, s.pair_type_id) AS "event_type", 
                COALESCE(z.module_id, s.f_organizations) AS "module_id",
                z.work_count,
                ctd.id AS "lesson_id", 
                COALESCE(z.tema_num, ctd.tema_num, s.lesson_num) AS "tema_num", 
                COALESCE(z.tema, ctd.tema) AS "tema", 
                COALESCE(z.goal, ctd.content) AS "content",  
                COALESCE(z.questions, ctd.questions) AS "questions", 
                COALESCE(z.methodical, ctd.methodical) AS "methodical", 
                COALESCE(z.books, ctd.books) AS "books", 
                COALESCE(z.additional_books, ctd.additional_books) AS "additional_books", 
                COALESCE(z.official_books, ctd.official_books) AS "official_books", 
                COALESCE(z.equipment, ctd.equipment) AS "equipment", 
                COALESCE(z.test_equipment, ctd.test_equipment) AS "test_equipment", 
                z.iscontrol, z.issecret, z.isopen, 
                COALESCE(z.lesson_number, ctd.num) AS "lesson_number", 
                COALESCE(h.work_hours, ctd.hw_hours) AS "hw_hours",
                COALESCE(h.text, ctd.homework) AS "homework", 
                ctd.lesson_type,
                v.lesson_date,
                STRING_AGG(per.name, ', ') AS "learn_hours",
                r.name AS "roomname",
                gn.name AS "groupname",
                peo.lastname || ' ' || LEFT(peo.firstname, 1) || '.' || LEFT(peo.patronymic, 1) || '.' AS "fio",
                cat.cathedra,
                COALESCE(z.questions, ctd.questions) as "questions",
                COALESCE(z.goal, ctd.content) as "content",
                COALESCE(z.methodical, ctd.methodical) as "educational_goals"
            FROM vw_schedule v
            JOIN nnz_schedule s ON v.sheid = s.sheid 
            LEFT JOIN groupname gn ON gn.gid = s.gid
            LEFT JOIN periods per ON per.lid = s.period
            LEFT JOIN cathedras cat ON cat.idcathedra = s.idcathedra
            LEFT JOIN rooms r ON r.rid = ANY(s.rid)
            LEFT JOIN people peo ON peo.mid = ANY(s.teacher_mid)
            LEFT JOIN nnz_schedule_modules z ON z.week_id = v.week_id AND z.sheid = v.sheid 
            LEFT JOIN nnz_homework h ON h.sheid = v.sheid AND h.week_id = v.week_id
            LEFT JOIN course_tema_detail ctd ON ctd.id = COALESCE(z.course_tema_detail, s.course_tema_detail_id) 
            WHERE v.sheid = :sheid and v.week_id = :week_id
            GROUP BY 
                z.sh_mod_id, 
                ctd.id, 
                COALESCE(z.event_type, ctd.eventtool, s.pair_type_id), 
                COALESCE(z.module_id, s.f_organizations),
                z.work_count,
                COALESCE(z.tema_num, ctd.tema_num, s.lesson_num), 
                COALESCE(z.tema, ctd.tema), 
                COALESCE(z.goal, ctd.content),  
                COALESCE(z.questions, ctd.questions), 
                COALESCE(z.methodical, ctd.methodical), 
                COALESCE(z.books, ctd.books), 
                COALESCE(z.additional_books, ctd.additional_books), 
                COALESCE(z.official_books, ctd.official_books), 
                COALESCE(z.equipment, ctd.equipment), 
                COALESCE(z.test_equipment, ctd.test_equipment), 
                z.iscontrol, z.issecret, z.isopen, 
                COALESCE(z.lesson_number, ctd.num), 
                COALESCE(h.work_hours, ctd.hw_hours),
                COALESCE(h.text, ctd.homework), 
                ctd.lesson_type,
                v.lesson_date,
                r.name,
                gn.name,
                peo.lastname || ' ' || LEFT(peo.firstname, 1) || '.' || LEFT(peo.patronymic, 1) || '.',
                cat.cathedra,
                COALESCE(z.questions, ctd.questions),
                COALESCE(z.goal, ctd.content),
                COALESCE(z.methodical, ctd.methodical)
        """

        stmt = text(sql)
        stmt = stmt.bindparams(sheid=sheid)
        stmt = stmt.bindparams(week_id=week_id)
        query = conn.execute(stmt)

        result = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        # Convert Decimal to float
        for row in result:
            for key, value in row.items():
                if isinstance(value, Decimal):
                    row[key] = float(value)

        return result

    def update_class_topic(self, lname, sheid, week_id, data):
        conn = current_app.ms.db(lname).connect()
        trans = conn.begin()
        try:
            sql = """select * from nnz_schedule_modules WHERE sheid = :sheid and week_id = :week_id"""
            stmt = text(sql).bindparams(sheid=sheid, week_id=week_id)
            query = conn.execute(stmt)
            result = query.fetchall()

            if not result:
                sql = """
                    INSERT INTO nnz_schedule_modules (
                        sheid, week_id, event_type, module_type, module_id, course_tema_detail, work_count, IsControl, IsSecret, 
                        IsOpen, lesson_number, tema_num, tema, goal, books, equipment, test_equipment, official_books, 
                        additional_books, questions, methodical
                    )
                    VALUES (:sheid, :week_id, :event_type, 'module', :module_id, NULLIF(:course_tema_detail_id,0), 
                        NULLIF(:work_count,0), :IsControl, (:IsSecret<>0), (:IsOpen<>0), 
                        NULLIF(:lesson_number,0), :tema_num, :tema, :goal, :books, :equipment, :test_equipment, 
                        :official_books, :additional_books, :questions, :methodical); 
                    """
            else:
                sql = """
                    UPDATE nnz_schedule_modules SET 
                        event_type = :event_type, module_id = :module_id, course_tema_detail = NULLIF(:course_tema_detail_id, 0), 
                        work_count = NULLIF(:work_count, 0), IsControl = :IsControl, IsSecret = (:IsSecret<>0), IsOpen = (:IsOpen<>0), 
                        lesson_number = NULLIF(:lesson_number, 0), tema_num = :tema_num, tema = :tema, goal = :goal, books = :books, 
                        equipment = :equipment, test_equipment = :test_equipment, official_books = :official_books, 
                        additional_books = :additional_books, questions = :questions, methodical = :methodical
                    WHERE sheid = :sheid AND week_id = :week_id
                """

            stmt = text(sql).bindparams(
                sheid=sheid,
                week_id=week_id,
                event_type=data["event_type"],
                module_id=data["module_id"],
                course_tema_detail_id=data.get("course_tema_detail_id", 0),
                work_count=data["work_count"] if data["work_count"] else None,
                IsControl=data["iscontrol"],
                IsSecret=int(data["issecret"]) if data["issecret"] else None,
                IsOpen=int(data["isopen"]) if data["isopen"] else None,
                lesson_number=data.get("lesson_number", 0),
                tema_num=data["tema_num"],
                tema=data["tema"],
                goal=data["content"],
                books=data["books"],
                equipment=data["equipment"],
                test_equipment=data["test_equipment"],
                official_books=data["official_books"],
                additional_books=data["additional_books"],
                questions=data["questions"],
                methodical=data["methodical"],
            )
            conn.execute(stmt)
            trans.commit()
            return True
        except Exception as e:
            print(e)
            trans.rollback()
            return False

    def delete_class_topic(self, lname, sheid, week_id):
        conn = current_app.ms.db(lname).connect()
        trans = conn.begin()
        try:
            sql = "DELETE FROM nnz_schedule_modules WHERE sheid = :sheid AND week_id = :week_id"
            stmt = text(sql).bindparams(
                sheid=sheid,
                week_id=week_id,
            )
            conn.execute(stmt)
            trans.commit()
            return True
        except Exception as e:
            print(e)
            trans.rollback()
            return False

    def get_plan_table(self, lname, course_tema_detail_id):
        conn = current_app.ms.db(lname).connect()

        if course_tema_detail_id is not None:
            sql = """
                select id, name, part_time, content,questions, coalesce(part,1) as part,num from lesson_parts 
                where course_tema_detail = :course_tema_detail_id and coalesce(part,1) in (0,1,2) order by num
            """

            stmt = text(sql)
            stmt = stmt.bindparams(course_tema_detail_id=course_tema_detail_id)
            query = conn.execute(stmt)

            return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        else:
            return []

    def get_electronic_test(self, lname, sheid, week_id, mid_list):
        conn = current_app.ms.db(lname).connect()

        sql = """
                SELECT p.mid, xp_format_fio(p.lastname, p.firstname, p.patronymic, 1) as fio, 
                       a.id, a.grade, a.comment 
                FROM people p 
                LEFT JOIN etest_request q ON q.sheid = :sheid AND q.week_id = :week_id 
                LEFT JOIN etest_result a ON a.request = q.id AND a.student_mid = p.mid 
                WHERE p.mid IN :mid_list
                ORDER BY 2
            """

        stmt = text(sql)
        stmt = stmt.bindparams(sheid=sheid, week_id=week_id, mid_list=tuple(mid_list))
        query = conn.execute(stmt)

        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]


def get_filters(security, open_lesson, their_lesson):
    filters = """"""
    if security == 1:
        filters += """
            DELETE FROM Journal j 
            USING nnz_schedule_modules m 
            WHERE m.sheid=j.sheid and m.week_id=j.instance and not coalesce(m.issecret,false); 
            DELETE FROM Journal j 
            WHERE sheid>0 and NOT EXISTS (SELECT 1 FROM nnz_schedule_modules m WHERE m.sheid=j.sheid and m.week_id=j.instance); 
        """
    if open_lesson == 1:
        filters += """
            DELETE FROM Journal j 
            USING nnz_schedule_modules m 
            WHERE m.sheid=j.sheid and m.week_id=j.instance and not coalesce(m.isopen,false); 
            DELETE FROM Journal j 
            WHERE sheid>0 and NOT EXISTS (SELECT 1 FROM nnz_schedule_modules m WHERE m.sheid=j.sheid and m.week_id=j.instance); 
        """

    where = """"""
    if their_lesson == 1:
        where += """
            WHERE 1=1 and 2 = Any(journal.TeacherMid)
        """
    return filters, where
