from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app, g
import pickle


class MetaCourse:
    def __init__(self):
        self.idmetacourse = 0
        self.name = ""

    def serialize(self):
        return {
            "idmetacourse": self.idmetacourse,
            "name": self.name,
        }

    def get_course_list_from_redis(self, lname, groupid, termid):
        cachedClist = current_app.ms.redis(lname).get(
            "SYSCOLIST" + str(groupid) + str(termid)
        )
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def set_group_list_to_redis(self, lname, clist, groupid, termid):
        current_app.ms.redis(lname).setex(
            "SYSCOLIST" + str(groupid) + str(termid), 5, pickle.dumps(clist)
        )
        return

    def getAllMetaCourse(self, lname):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT id AS idmetacourse, name FROM meta_course ORDER BY name ASC"""

        stmt = text(sql)
        query = conn.execute(stmt)

        result = {
            "meta_course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        if len(result["meta_course"]) == 0:
            return None

        return result

    def getMetaCourseByYearCorriculumCourse(self, lname, syid, idcurriculum, cid):
        conn = current_app.ms.db(lname).connect()

        sql = """SELECT mc.id AS idmetacourse, concat_ws(' ', nullif(trim(mc.code), ''), nullif(trim(mc.name), ''))::character varying(254) as "name"
        FROM meta_course mc
        WHERE mc.id IN (
            SELECT DISTINCT k.meta_course
            FROM courses k
            JOIN q_demand_disciplines d1 ON d1.cid = k.cid
            JOIN curriculum clm ON clm.q_demand_id = d1.q_demand_id
            JOIN studyyears2curriculum s2c ON s2c.idcurriculum = clm.idcurriculum
            WHERE 1=1
                """

        if syid != 0:
            sql = sql + " AND s2c.syid = :syid "
        if idcurriculum != 0:
            sql = sql + " AND clm.idcurriculum = :idcurriculum "
        if cid != 0:
            sql = sql + " AND k.cid = :cid "

        sql = (
            sql
            + """) 
            ORDER BY 2"""
        )

        stmt = text(sql)
        if syid != 0:
            stmt = stmt.bindparams(syid=syid)
        if idcurriculum != 0:
            stmt = stmt.bindparams(idcurriculum=idcurriculum)
        if cid != 0:
            stmt = stmt.bindparams(cid=cid)
        query = conn.execute(stmt)

        result = {
            "meta_course": [dict(zip(tuple(query.keys()), i)) for i in query.cursor]
        }

        if len(result["meta_course"]) == 0:
            return None

        return result

    def get_meta_course_by_cathedra(self, lname, idcathedra, idcurriculum):
        conn = current_app.ms.db(lname).connect()

        sql = """
            SELECT  
                mc.id, 
                mc.name 
            FROM  meta_course mc 
            WHERE mc.id in ( 
                SELECT crs.meta_course
                FROM courses crs 
				JOIN curriculum_detail cd on cd.cid=crs.cid 
                LEFT JOIN studyyears2curriculum s2c ON s2c.idcurriculum = cd.idcurriculum
                WHERE cd.idcurriculum = :idcurriculum or :idcurriculum = 0 
            ) 
            AND (:idcathedra=0 OR mc.id IN (
                SELECT meta_course 
                FROM l_mcourse_cathedra 
                WHERE idcathedra=:idcathedra
            )) 
            ORDER BY mc.name 
            """

        stmt = text(sql)
        stmt = stmt.bindparams(idcathedra=idcathedra, idcurriculum=idcurriculum)
        query = conn.execute(stmt)
        return [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

    def get_lesson_plans_metacourses(self, lname, idcurriculum, syid, cid):
        conn = current_app.ms.db(lname).connect()

        base_sql = """
        select mc.id as idmetacourse, concat_ws(' ', nullif(trim(mc.code), ''), nullif(trim(mc.name), ''))::character varying(254) as "name"
        from meta_course mc
        where mc.id in (select k.meta_course from courses k where k.cid in (%(course_ids)s))
        order by 2
        """
        course_ids_placeholder = 0

        if cid != 0:
            course_ids_placeholder = cid

        elif idcurriculum != 0:
            # Get Course IDs based on curriculum
            course_ids_query = """
            select array_to_string(array_agg(distinct c.cid), ',')
            from courses c
            inner join curriculum_detail cd on cd.cid = c.cid
            join curriculum clm on clm.idcurriculum = cd.idcurriculum
            join qualif_demands q on q.q_demand_id = clm.q_demand_id
            where cd.idcurriculum = :idcurriculum
            and c.cid in (
                select cid from q_demand_disciplines where q_demand_id = q.q_demand_id
                union select cid from q_demand_ovp where q_demand_id = q.q_demand_id
                union select cid from q_demand_practice where q_demand_id = q.q_demand_id
                union select cid from q_demand_req where q_demand_id = q.q_demand_id
                union select cid from q_demand_tsu where q_demand_id = q.q_demand_id
            )
            """
            course_ids_stmt = text(course_ids_query).bindparams(
                idcurriculum=idcurriculum
            )
            course_ids_result = conn.execute(course_ids_stmt).fetchone()
            if course_ids_result and course_ids_result[0]:
                course_ids_placeholder = course_ids_result[0]

        elif syid != 0:
            curriculum_ids_query = """
            select array_to_string(array_agg(distinct c.idcurriculum), ',')
            from curriculum c 
            left join studyyears2curriculum  as s2c ON s2c.idcurriculum = c.idcurriculum 
            inner join qualif_demands q on q.q_demand_id = c.q_demand_id
            left join groupname g ON g.f_militaryprofession = q.mpid and g.syid = s2c.syid 
            inner join militaryprofession m on q.mpid = m.mpid
            left join edu_direction e on e.edu_direct_id = m.edu_direct_id
            left outer join (SELECT distinct f.faculty, l.f_militaryprofession as mpid  
                             FROM l_cath_milprof l   
                             left outer join cathedras ct on ct.idcathedra = l.f_cathedras    
                             left outer join faculty f on f.idfaculty = ct.faculty limit 1) fac ON fac.mpid = m.mpid  
            left outer join StudyYears2curriculum s2 on c.idcurriculum = s2.idcurriculum 
            left outer join StudyYears sy on s2.syid = sy.syid 
            where 1=1 AND sy.syid = :syid
            """
            curriculum_ids_stmt = text(curriculum_ids_query).bindparams(syid=syid)
            curriculum_ids_result = conn.execute(curriculum_ids_stmt).fetchone()
            if curriculum_ids_result and curriculum_ids_result[0]:
                curriculum_ids_placeholder = curriculum_ids_result[0]

            course_ids_query = """
            select array_to_string(array_agg(distinct c.cid), ',')
            from courses c
            inner join curriculum_detail cd on cd.cid = c.cid
            join curriculum clm on clm.idcurriculum = cd.idcurriculum
            join qualif_demands q on q.q_demand_id = clm.q_demand_id
            where cd.idcurriculum in (%(curriculum_ids)s)
            and c.cid in (
                select cid from q_demand_disciplines where q_demand_id = q.q_demand_id
                union select cid from q_demand_ovp where q_demand_id = q.q_demand_id
                union select cid from q_demand_practice where q_demand_id = q.q_demand_id
                union select cid from q_demand_req where q_demand_id = q.q_demand_id
                union select cid from q_demand_tsu where q_demand_id = q.q_demand_id
            )
            """
            course_ids_stmt = text(
                course_ids_query % {"curriculum_ids": curriculum_ids_placeholder}
            )
            course_ids_result = conn.execute(course_ids_stmt).fetchone()
            if course_ids_result and course_ids_result[0]:
                course_ids_placeholder = course_ids_result[0]

        sql = base_sql % {
            "course_ids": course_ids_placeholder,
        }

        stmt = text(sql)
        query = conn.execute(stmt)

        metacourseList = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return metacourseList
