from flask import current_app
from sqlalchemy import text

from LMSAPI.api.utils.database import Database


class ComplexThemePlanStream:
    @classmethod
    def create_plan_stream(cls, args: dict, lname: str) -> list:
        sql = """
            select
                ctps.id_ctps,
                ctps.title as stream,
                c.cname as study_plan,
                CONCAT_WS(', ', NULLIF(courses.course_index, ''), courses.title) AS discipline,
                string_agg(xp_fget_group_name(ctpsg.gid, ctps.id_school_year), ',') as membership, 
                ey.name as course,
                tl.name as term,
                coalesce(
                    CAST((SELECT sum(ctpsi.hours) 
                    FROM complex_thematic_planning_stream_items ctpsi 
                    WHERE ctpsi.id_ctps = ctps.id_ctps) AS INTEGER), 0
                ) as hours,
                NULL as file,
                NULL as status
            from (
                select distinct on (ctps.id_ctps)
                  ctps.*, ctpsg.id_curriculum_course
                from complex_thematic_planning_stream ctps
                  left outer join complex_thematic_planning_stream_groups ctpsg on ctpsg.id_ctps = ctps.id_ctps
            
                order by
                  ctps.id_ctps,
                  ctpsg.is_main desc
            ) ctps
            
            inner join termslist tl on tl.tlid = ctps.id_termslist
            inner join educationyears ey on ey.eyid = tl.eyid
            inner join curriculum_course cc on cc.id_curriculum_course = ctps.id_curriculum_course
            inner join curriculum_detail cd on cd.id_curr_detail = any(cc.id_curr_details || cc.id_curr_detail)
            inner join curriculum c on c.idcurriculum = cd.idcurriculum
            inner join qualif_demands qd on qd.q_demand_id = c.q_demand_id
            inner join militaryprofession mp on mp.mpid = qd.mpid
            inner join courses on courses.cid = cd.cid
            left outer join complex_thematic_planning_stream_groups ctpsg on ctpsg.id_ctps = ctps.id_ctps
        
            where 1=1
            {where}
            group by
              ctps.id_ctps, ctps.title, c.cname, courses.course_index, courses.title, ey.name,
              tl.name, ey.number, tl.sorting
            order by
              c.cname, courses.title, ey.number, tl.sorting, ctps.title
        """.format(
            where=cls._plan_filters(args)
        )

        return Database(lname).execute_select(sql)

    @staticmethod
    def _plan_filters(filters_dict: dict) -> str:
        result_where = ""
        for param in filters_dict:
            if param == "year_id" and int(filters_dict.get("year_id")) != 0:
                result_where += " and ctps.id_school_year = {year_id}".format(
                    year_id=filters_dict["year_id"]
                )
            elif param == "cathedra_id" and int(filters_dict.get("cathedra_id")) != 0:
                result_where += """ and qd.mpid IN 
                        (select f_militaryprofession from l_cath_milprof l 
                            join cathedras cat on cat.idcathedra = l.f_cathedras 
                            where cat.idCathedra = {cathedra_id})""".format(
                    cathedra_id=filters_dict["cathedra_id"]
                )
            elif (
                param == "curriculum_id" and int(filters_dict.get("curriculum_id")) != 0
            ):
                result_where += " and c.idcurriculum = {curriculum_id} ".format(
                    curriculum_id=filters_dict["curriculum_id"]
                )
            elif param == "course_id" and int(filters_dict.get("course_id")) != 0:
                result_where += " and courses.cid = {course_id}".format(
                    course_id=filters_dict["course_id"]
                )

        return result_where
