# coding=UTF-8
# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Progress:

    def __init__(self, cname):
        self.lname = cname

    def getProgress(self, uid, yearid):

        conn = current_app.ms.db(self.lname).connect()

        sqlt = "SELECT trmid FROM terms WHERE year =:yearid"
        stmt = text(sqlt)
        stmt = stmt.bindparams(yearid=yearid)
        query = conn.execute(stmt)

        terms = []


        for row in query:
            terms.append(row.trmid)

        sqlt = "DROP TABLE IF EXISTS tmpgradebook_summary"
        stmt = text(sqlt)
        query = conn.execute(stmt)

        first = True
        for termid in terms:
            if first:
                sql = """SELECT xp_fill_report_gradebook(:uid, :termid); 
                        CREATE TEMP TABLE tmpgradebook_summary AS
                        select tmpgradebook.* 
                        from tmpgradebook
                        left outer join eventtools et on tmpgradebook.typeid = et.typeid
                        where trmtid IN (7,8) OR et.processtypeid = 3
                        ORDER BY kurs, termNum,certdate;"""
                first = False
            else:
                sql = """SELECT xp_fill_report_gradebook(:uid, :termid); 
                        insert into tmpgradebook_summary 
                        select tmpgradebook.* 
                        from tmpgradebook
                        left outer join eventtools et on tmpgradebook.typeid = et.typeid
                        where trmtid IN (7,8) OR et.processtypeid = 3
                        ORDER BY kurs, termNum,certdate;"""

            stmt = text(sql)
            stmt = stmt.bindparams(uid=uid)
            stmt = stmt.bindparams(termid=termid)
            query = conn.execute(stmt)

        sql = """SELECT xp_fill_report_gradebook(:uid, :semesterid);
                select *,to_char(certdate,'DD.MM.YYYY') as certdate_txt  FROM tmpgradebook
                ORDER BY kurs, termNum,certdate;"""

        sql = """SELECT *, to_char(certdate,'DD.MM.YYYY') as certdate_txt,
                    CASE grade 
                         WHEN 'отл.' THEN 'ОТЛИЧНО'
                         WHEN 'хор.' THEN 'ХОРОШО'
                         WHEN 'уд.' THEN 'УДОВЛЕТ.'
                         WHEN 'зач.' THEN 'ЗАЧТЕНО'
                         WHEN 'неуд.' THEN 'НЕУДОВЛЕТ.'
                    END as grade,
                    regexp_replace(regexp_replace(course,'\d+', ''), '\s+$', '')  as course
                FROM tmpgradebook_summary 
                ORDER BY kurs, termNum, certdate;"""

        if first:
            return None

        stmt = text(sql)
        query = conn.execute(stmt)

        gradeBook = [dict(zip(tuple(query.keys()), i)) for i in query.cursor]

        return gradeBook


    def getProgressDetail(self,uid,semesterid,courseid):

        conn = current_app.ms.db(self.lname).connect()
        

        sql = """SELECT nnz_fill_journalstudent_detail(:semesterid, :uid, :courseid, '01.01.2001', '01.01.2001');
SELECT * ,to_char(lessonfulldate,'DD.MM.YYYY') as lessonfulldate_txt 
FROM JournalStudent_detail
ORDER BY lessonfulldate;"""

        stmt = text(sql)
        stmt = stmt.bindparams(uid=uid)    
        stmt = stmt.bindparams(semesterid=semesterid)    
        stmt = stmt.bindparams(courseid=courseid)    
        query = conn.execute(stmt)


 
        gradeBook = {'progressDetail': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}

        return gradeBook


    def getTotalProgress(self,uid,yearid):

        conn = current_app.ms.db(self.lname).connect()
        


        sqlt = "SELECT trmid FROM terms WHERE year =:yearid"
        stmt = text(sqlt)
        stmt = stmt.bindparams(yearid=yearid)            
        query = conn.execute(stmt)

        terms = []

        for row in query:                                
            terms.append(row.trmid)

        sqlt = "DROP TABLE IF EXISTS tmpgradebook_summary"
        stmt = text(sqlt)
        query = conn.execute(stmt)

        first = True
        for termid in terms:            
            if first:
                sql = """SELECT xp_fill_report_gradebook(:uid, :termid); 
CREATE TEMP TABLE tmpgradebook_summary AS
select tmpgradebook.* 
from tmpgradebook
left outer join eventtools et on tmpgradebook.typeid = et.typeid
where  et.processtypeid = 8
ORDER BY kurs, termNum,certdate;"""
                first = False
            else:
                sql = """SELECT xp_fill_report_gradebook(:uid, :termid); 
insert into tmpgradebook_summary 
select tmpgradebook.* 
from tmpgradebook
left outer join eventtools et on tmpgradebook.typeid = et.typeid
where  et.processtypeid = 8
ORDER BY kurs, termNum,certdate;"""

            stmt = text(sql)
            stmt = stmt.bindparams(uid=uid)    
            stmt = stmt.bindparams(termid=termid)    
            query = conn.execute(stmt)


        sql = """SELECT xp_fill_report_gradebook(:uid, :semesterid);
select *,to_char(certdate,'DD.MM.YYYY') as certdate_txt  FROM tmpgradebook
ORDER BY kurs, termNum,certdate;"""

        sql = """SELECT *,to_char(certdate,'DD.MM.YYYY') as certdate_txt  FROM tmpgradebook_summary ORDER BY kurs, termNum,certdate;"""

        if first:
            return None


        stmt = text(sql)        
        query = conn.execute(stmt)

        gradeBook = [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]

        return gradeBook
