# LMSAPI/API/Room.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.User import User
from flask import current_app
import pickle




class Room:

    def __init__(self,cname):
        self.rid=1
        self.name=""
        self.short_name=""
        self.tfoid = ""
        self.short_title = ""
        self.full_title = ""
        self.capacity_students = ""
        self.file_types = {
            "panorama": File(cname).getRoomsPanoramaDirectory,
            "photo": File(cname).getRoomsPhotoDirectory,
        }
        self.lname = cname

    def serialize(self):  
        return {           
        'rid': self.rid,
        'name': self.name,
        'short_name': self.short_name,
        'tfoid': self.tfoid,
        'short_title': self.short_title,
        'full_title': self.full_title,
        'capacity_students': self.capacity_students
        }

   
    def getRoom(self,lname,id):

        fc = Room(lname)

        conn = current_app.ms.db(lname).connect()
  
        stmt = text("""
            SELECT rooms.rid, rooms.name, rooms.short_name,
                training_facilites_objects.tfoid, training_facilites_objects.short_title,
                training_facilites_objects.full_title, training_facilites_objects.capacity_students
            FROM rooms
            JOIN training_facilites_objects ON 
            rooms.tfoid = training_facilites_objects.tfoid
            WHERE rid = :id
        """)
        stmt = stmt.bindparams(id=id)    
        query = conn.execute(stmt)

        result = {'room': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}
    
        if len(result['room']) == 0:
            return None


        return result

    def getRoomList(self,lname):

        f = Room(lname)
        
        conn = current_app.ms.db(lname).connect()
        
        query = conn.execute("""
        SELECT rooms.rid, rooms.name, rooms.short_name,
            training_facilites_objects.tfoid, training_facilites_objects.short_title,
            training_facilites_objects.full_title, rooms.volume
        FROM rooms
        JOIN training_facilites_objects ON 
        rooms.tfoid = training_facilites_objects.tfoid
        """)

        roomList = []

        for row in query:
            room = Room("")
            room.rid = row.rid
            room.name = row.name
            room.short_name = row.short_name
            room.tfoid = row.tfoid
            room.short_title = row.short_title
            room.full_title = row.full_title
            room.capacity_students = row.volume
            roomList.append(room)

        return roomList

    def getRoomByDate(self,lname,date,tfoid):
        conn = current_app.ms.db(lname).connect()
        where = ""
        if tfoid is not None:
            where = " AND training_facilites_objects.tfoid = :tfoid"
        query = conn.execute("""
            select nnz_fill_scheduling(
                (
                    SELECT 
                        sh_var_id
                    FROM public.nnz_weeks
                    WHERE '{date}' BETWEEN wstart_date AND wend_date
                ),0,0,0
            );


            select 
                    gid, -- ссылка на группу
                    groupname,
                    period, -- номер пары
                    periodname,
                    roomid, -- аудитории
                    roomname,
                    training_facilites_objects.tfoid,
                    training_facilites_objects.full_title,
                    training_facilites_objects.short_title
                    
            from SchedulingT
            join rooms on rooms.rid = ANY(roomid)
            join training_facilites_objects on rooms.tfoid = training_facilites_objects.tfoid
            where 1=1
                {where}
            """.format(
                date=date,
                where=where
            )
        )

        result = {'room': [dict(zip(tuple(query.keys()) ,i)) for i in query.cursor]}
        return result
    
    def getRoomPhotoAndPanorama(self,lname,rid):
        file = File(lname)
        photo_files = file.getRoomsPhotoFiles(rid)
        panorama_files = file.getRoomsPanoramaFiles(rid)

        return {
            'photo_files': photo_files,
            'panorama_files': panorama_files
        }
    
    def getRoomPhotoOrPanorama(self, rid, ftype):
        
        file = self.file_types.get(ftype)
        if not file:
            return None
        
        return file(rid)