# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle

class Schoolyear:

    def __init__(self,cname):
        self.lname = cname
   
    def getListFromRedis(self):
        cachedClist = current_app.ms.redis(self.lname).get("SYSSCYLIST")
        if cachedClist is not None:
            clist = pickle.loads(cachedClist)
            return clist
        return

    def setListToRedis(self,ylist):
        current_app.ms.redis(self.lname).setex("SYSSCYLIST",5,pickle.dumps(ylist))
        return

    def getSchoolYearList(self):
        studyyearList = self.getListFromRedis()
        if studyyearList is not None:
            return studyyearList

        conn = current_app.ms.db(self.lname).connect()
        stmt = text("select xp_key,name,TO_CHAR(begdate::DATE,'dd-mm-yyyy') begdate,TO_CHAR(enddate::DATE,'dd-mm-yyyy') enddate,year_grade_types from school_year order by begdate desc")
        query = conn.execute(stmt)
        studyyearList = {'schoolYear': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}

        self.setListToRedis(studyyearList)
        return studyyearList

    def getSchoolYear(self,id):

        conn = current_app.ms.db(self.lname).connect()
        
        stmt = text("select xp_key,name,TO_CHAR(begdate::DATE,'dd-mm-yyyy') begdate,TO_CHAR(enddate::DATE,'dd-mm-yyyy') enddate,year_grade_types from school_year  where xp_key=:id")
        stmt = stmt.bindparams(id=id)    
        query = conn.execute(stmt)

        studyyearList = {'schoolYear': [dict(zip(tuple (query.keys()) ,i)) for i in query.cursor]}

      
        return studyyearList

    def getCurrentSchoolYear(self):
        conn = current_app.ms.db(self.lname).connect()

        stmt = text("""
            SELECT 
                xp_key,
                name,
                TO_CHAR(begdate::DATE, 'dd-mm-yyyy') AS begdate,
                TO_CHAR(enddate::DATE, 'dd-mm-yyyy') AS enddate,
                year_grade_types
            FROM school_year
            WHERE CURRENT_DATE BETWEEN begdate AND enddate
            LIMIT 1
        """)

        query = conn.execute(stmt)
        result = [dict(zip(query.keys(), row)) for row in query.cursor]

        return result[0] if result else None