# LMSAPI/API/Faculty.py

from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import current_app
import pickle
import urllib, json, sys
#import asyncio  

class Status:

   
    def __init__(self,cname):
        self.lname = cname
   
    def checkRedis(self):

        try:
            cachedClist = current_app.ms.redis(self.lname).get("SYSSCYLIST")
        except Exception as e:
            current_app.logger.error('REDIS Error:' + str(e))
            return "ERROR: " + str(e)
        
        return "OK"

    def checkDb(self):

        try:
            conn = current_app.ms.db(self.lname).connect()        
            stmt = text("select count(*) from school_year")
            query = conn.execute(stmt)
        except Exception as e:
            current_app.logger.error('DB Error: '+ str(e))
            return "ERROR: " +str(e)
      
        return "OK"


    def checkLibrary(self):

        try:
            if current_app.ms.libraryurl(self.lname) =="":
                return "N/A"
            if current_app.ms.librarykey(self.lname) == "":
                return "N/A"
            
            url = current_app.ms.libraryurl(self.lname) + "/hlms/test"

            try:
                from urllib.request import Request, urlopen  # Python 3
            except ImportError:
                from urllib2 import Request, urlopen  # Python 2

            req = Request(url)
            req.add_header('x-hlms-apikey',current_app.ms.librarykey(self.lname))

            current_app.logger.debug(url)

            data = urlopen(req).read()
            if sys.version_info[0] < 3:
                dataDict = json.loads(data)
            else:
                dataDict = json.loads(data.decode('utf-8'))

            return dataDict


        except Exception as e:
            current_app.logger.error('LIBRARY INTEGRATION Error: '+ str(e))
            return "ERROR: " +str(e)
      
        return "OK"