from flask import jsonify, request, current_app, g, send_from_directory
from flask import Blueprint
import json

from LMSAPI.api.Models.Buildings import Buildings
from LMSAPI.api.Models.File import File
# from LMSAPI.api.Views.TokenAPI import auth
# from LMSAPI.api.Models.Cathedra import Cathedra
from flask_cors import CORS

from LMSAPI.api.Models.EducationStandards import EducationStandards
from LMSAPI.api.Views.TokenAPI import auth

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

buildings_api = Blueprint('buildings_api', __name__)

CORS(buildings_api)


# Get all train areas
@buildings_api.route('/lms/api/v1.0/<lname>/all_buildings', methods=['GET'])
def getAllBuildings(lname):
    """GET a list of train directions"""
    B = Buildings(lname)
    result = B.get_all_buildings()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result), 200

