from flask import Flask, jsonify, request, current_app, g
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.EducationWorkProgram import Educationworkprogram
from flask_cors import CORS

from LMSAPI.api.utils.access_utils import user_permission_modes

educationworkprogram_api = Blueprint("educationworkprogram_api", __name__)

CORS(educationworkprogram_api)


@educationworkprogram_api.route(
    "/lms/api/v1.0/<lname>/educationworkprogram/<int:idcurriculum>/<int:courseid>",
    methods=["GET"],
)
@auth.login_required
@user_permission_modes("Справочники", "Рабочие программы дисциплин (модулей)", ["Нет"])
def getEducationWorkProgram(lname, idcurriculum, courseid):
    id_curriculum_course = request.args.get("id_curriculum_course")
    paginateFrom = request.args.get("paginateFrom")
    maxResults = request.args.get("maxResults")

    result = Educationworkprogram(lname).getEducationWorkProgram(
        idcurriculum, courseid, id_curriculum_course, paginateFrom, maxResults
    )
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)
