from flask_cors import CORS
from flask import jsonify, request, current_app, g, send_from_directory, Blueprint

from LMSAPI.api.Models.Hero import Hero

hero_api = Blueprint('hero_api', __name__)

CORS(hero_api)


@hero_api.route('/lms/api/v1.0/<lname>/hero', methods=['GET'])
# @auth.login_required
def get_hero_list(lname):
    """GET to generate a list of endpoints and their docstrings"""
    hero_list = Hero.get_heroes(lname)

    return jsonify(hero_list=hero_list), 200