from flask import Flask,jsonify
from sqlalchemy import create_engine
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.Holidays import Holidays
from flask_cors import CORS

holidays_api = Blueprint('holidays_api', __name__)

CORS(holidays_api)

@holidays_api.route('/lms/api/v1.0/<lname>/holidays', methods=['GET'])
def getHolidaysList(lname):
    holidaysList = Holidays().getHolidaysList(lname)
    
    if holidaysList is None:
        return jsonify(success=False),404

    return jsonify(holidaysList)   