# coding=UTF-8
from flask import Flask,jsonify, request, current_app,g
from flask_restful import Resource,Api
from flask import Blueprint,url_for
from flask_cors import CORS
import pickle,platform,urllib,sys,json
from LMSAPI.api.Views.TokenAPI import auth


library_api = Blueprint('library_api', __name__)

CORS(library_api)

@library_api.route('/lms/api/v1.0/<lname>/ library/<path:text>', methods=['GET', 'POST', 'DELETE','PUT'])
@auth.login_required
def all_routes(lname, text):
  print('1')
  if current_app.ms.libraryurl(lname) =="":
    return jsonify(success=False),404
  if current_app.ms.librarykey(lname) == "":
    return jsonify(success=False),404
  
  url = None
  
  P2 = False

  try:
    from urllib.request import Request, urlopen  # Python 3        
    url = current_app.ms.libraryurl(lname) + "/" + text + "?" + urllib.parse.urlencode(request.args) 
  except ImportError:    
    from urllib2 import Request, urlopen   # Python 2        
    data = urllib.urlencode(request.args)
    url = current_app.ms.libraryurl(lname) + "/" + text + "?" +data
    P2 = True
  
  try:
    if(request.method == "DELETE"):            
      req = Request(url)
      req.get_method = lambda: request.method
    elif(request.method == "PUT"):   
      if P2:      
        import base64          
        s = request.data.decode('utf-8').encode('utf-8')
        f = base64.b64encode(s)
        req = Request(url, f, {'Content-Type': 'application/basej64'})
      else:         
        req = Request(url, request.data, {'Content-Type': 'application/json'})
      req.get_method = lambda: request.method
    elif(request.method == "POST"):            
      if P2:      
        import base64          
        s = request.data.decode('utf-8').encode('utf-8')
        f = base64.b64encode(s)
        req = Request(url, f, {'Content-Type': 'application/basej64'})
      else:
        req = Request(url, request.data, {'Content-Type': 'application/json'})        
      req.get_method = lambda: request.method
    else:
      req = Request(url)
    
    req.add_header('x-hlms-apikey',current_app.ms.libraryaccesskey(lname))
    req.add_header('x-hlms-apiuserid',g.user.mid)
    data = urlopen(req)
    
    return data.read(),{'Content-Type': data.info()['Content-Type'], 'Content-Length': data.info()['Content-Length'] }

  except Exception as e: 
    return "Error ("+str(e)+") in REQUEST e "+ request.method + " " + url,500

  return "ERROR",405
