import os
from io import BytesIO

from flask import jsonify, current_app, send_from_directory, request, g, send_file
from flask import Blueprint
from flask_cors import CORS
from sqlalchemy import text

from LMSAPI import db
from LMSAPI.api.Models.File import File
from LMSAPI.api.Models.MethodicalPlan import MethodicalPlan
from LMSAPI.api.Views.TokenAPI import auth

methodical_plan_api = Blueprint('methodical_plan_api', __name__)

CORS(methodical_plan_api)


@methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/years", methods=["GET"])
@auth.login_required
def get_years_plan(lname):
    """ Года  """
    years = MethodicalPlan(lname).get_years_plan()
    return jsonify(years)


@methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/goals_and_objectives/<int:mpid>", methods=["GET"])
@auth.login_required
def get_goals_and_objectives(lname, mpid):
    """ Основные цели и задачи методической деятельности """
    goal_list = MethodicalPlan(lname).get_main_goals_and_objectives(mpid=mpid)
    return jsonify(goal_list)


@methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/decree/<int:mpid>", methods=["GET"])
@auth.login_required
def get_decree(lname, mpid):
    """ Организационно-методические указания """
    decree_list = MethodicalPlan(lname).get_decree(mpid=mpid)
    return jsonify(decree_list)


@methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/approved_plan/<int:mpid>", methods=["GET"])
@auth.login_required
def get_approved_plan(lname, mpid):
    """ Получение файла для "Утвержденный план" в "Главна" """
    value = MethodicalPlan(lname).get_approved_plan(mpid=mpid)
    if value:
        file = File(lname).get_approved_plan_fact_files(mpid)

        ip_address = (
                request.headers.get("X-Forwarded-For")
                or request.headers.get("X-Real-IP")
                or request.environ.get("REMOTE_ADDR")
        )
        return File.send_from_directory(
            lname=lname,
            file_path=File(lname).get_approved_plan_fact_directory(mpid),
            file_name=file[0]["file"],
            action_source=request.environ.get("HTTP_USER_AGENT"),
            login=g.user.id,
            user_mid=g.user.mid,
            ip_address=ip_address,
        )
    else:
        return jsonify({"error": "Данный план отсутствует"})


# @methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/approved_plan/<int:pid>", methods=["POST"])
# @auth.login_required
# def post_approved_plan(lname, pid):
#     """ Добавление/Замена файла для "Утвержденный план" в "Главна"(первая вкладка) """
#     value = MethodicalPlan(lname).get_approved_plan(pid=pid)
#     if value:
#         file = File(lname).get_approved_plan_fact_files(pid)
#         if file:
#             os.remove(
#                 os.path.join(
#                     File(lname).get_approved_plan_fact_directory(pid),
#                     file[0]["file"]
#                 )
#             )
#
#     ip_address = (
#             request.headers.get("X-Forwarded-For")
#             or request.headers.get("X-Real-IP")
#             or request.environ.get("REMOTE_ADDR")
#     )
#
#     submitted_file = request.files["file"]
#
#     if submitted_file:
#         File(lname).create_approved_plan_fact_directory(pid)
#         file_path = File(lname).get_approved_plan_fact_directory(pid)
#         return File.save_file_to_path(
#             lname=lname,
#             submitted_file=submitted_file,
#             file_path=file_path,
#             action_source=request.environ.get("HTTP_USER_AGENT"),
#             login=g.user.id,
#             user_mid=g.user.mid,
#             ip_address=ip_address,
#         )
#     return jsonify({"success": False, "error": "Требуется прикрепить файл"})
#
#
# @methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/approved_plan/<int:pid>", methods=["DELETE"])
# @auth.login_required
# def delete_approved_plan(lname, pid):
#     """ Удаление файла для "Утвержденный план" в "Главна"(первая вкладка) """
#     value = MethodicalPlan(lname).get_approved_plan(pid=pid)
#     if value:
#         file = File(lname).get_approved_plan_fact_files(pid)
#         if file:
#             try:
#                 os.remove(
#                     os.path.join(
#                         File(lname).get_approved_plan_fact_directory(pid), file[0]["file"]
#                     )
#                 )
#                 return jsonify(success=True)
#             except:
#                 return jsonify({"error": "Данный файл отсутствует"}), 404
#         return jsonify({"error": "Файл отсутствует"}), 404
#     return jsonify({"error": "Данный план отсутствует"}), 404


@methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/content_part/<int:mpid>", methods=["GET"])
@auth.login_required
def get_content_part(lname, mpid):
    """ Содержательная часть """
    content = {}
    content['Основные мероприятия'] = MethodicalPlan(lname).get_content_part(mpid=mpid, event_type=0)
    content['Внедрение новых технологий'] = MethodicalPlan(lname).get_content_part(mpid=mpid, event_type=1)
    content['Дополнительные мероприятия'] = MethodicalPlan(lname).get_content_part(mpid=mpid, event_type=2)

    return jsonify(content)


# @methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/content_part/part", methods=["GET"])
# @auth.login_required
# def get_part(lname):
#     """ Содержательная часть(четвертая вкладка при редактировании) -> Добавить -> Раздел """
#     content_part = MethodicalPlan(lname).get_part()
#     return jsonify(content_part)

@methodical_plan_api.route("/lms/api/v1.0/<lname>/methodical_plan/changes/<int:mpid>", methods=["GET"])
@auth.login_required
def get_changes(lname, mpid):
    """ Изменения """
    changes = MethodicalPlan(lname).get_changes(mpid=mpid)
    return jsonify(changes)
