from flask import Flask,jsonify, request, current_app,g
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Ooop import Ooop
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

ooop_api = Blueprint('ooop_api', __name__)

CORS(ooop_api)
@ooop_api.route('/lms/api/v1.0/<lname>/ooop', methods=['GET'])
@auth.login_required
def getOoop(lname):
    """GET to generate a list of endpoints and their docstrings"""
    result = Ooop(lname).getOoop(g.user.mid)

    if result is None:
        return jsonify(success=False),404

    return jsonify(result)