from flask import Flask,jsonify, request, current_app
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from flask_cors import CORS
from LMSAPI.api.Models.Organization import Organization 
import pickle

from LMSAPI.api.utils.access_utils import user_permission_modes

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

organization_api = Blueprint('organization_api', __name__)

CORS(organization_api)

@organization_api.route('/lms/api/v1.0/<lname>/organization', methods=['GET'])
def getOrganizationItems(lname):
    """GET organization tree"""
    orgTree = Organization().getOrganizationItems(lname)
    return jsonify(orgTree)
