from flask import Flask,jsonify, request, current_app,Response
from flask_restful import Resource,Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Company   import Company
from LMSAPI.api.Models.Links import Links
from flask_cors import CORS

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

settings_api = Blueprint('settings_api', __name__)

CORS(settings_api)


# Get all cathedras for a faculty
@settings_api.route('/lms/api/v1.0/<lname>/settings', methods=['GET'])
def getSettings(lname):
    """GET settings"""
    result = {}
    result['auth'] = {}
    result['auth']['sso'] = {}
    result['auth']['sso']['allowbasiclogin'] = current_app.config['AUTH_SSO_BASICLOGIN']

    return jsonify(result)

# Get all cathedras for a faculty
@settings_api.route('/lms/api/v1.0/<lname>/links', methods=['GET'])
def getLinks(lname):
    """GET links"""
    
    return jsonify(Links(lname).get_links())


@settings_api.route('/lms/api/v1.0/<lname>/links/<int:id>', methods=['GET'])
def getIcon(lname,id):
        
        
        result = Links(lname).get_link_image(id)

        if result is None:
                return jsonify(success=False),404

        response = Response(str(id))
        response.content_type = 'image/png'
        response.headers['Content-disposition'] = 'attachment; filename = ' +str(id)+ '.png'
        response.headers['Cache-control'] = 'max-age=86400'
        response.content_length = len(result)
        response.data = result
        
        return response