from flask import Flask,jsonify, request, current_app
from flask_restful import Resource,Api
from flask import Blueprint,url_for
from flask_cors import CORS
import pickle,platform,urllib
#import asyncio  
from LMSAPI.api.Models.Status import Status
# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

status_api = Blueprint('status_api', __name__)

CORS(status_api)

@status_api.route('/lms/api/v1.0/<lname>/status', methods=['GET'])
def getStatus(lname):
    """GET gives status of system"""
    from LMSAPI.api.Views.VersionAPI import getVersion

    x = getVersion()
    import json
    vers = json.loads(x.data.decode("utf-8"))
    st = Status(lname)

   
    a  =   st.checkDb()
    b =  st.checkRedis()
    c = st.checkLibrary()

    statusInfo = {
      'instnace': lname
    , 'host': platform.node()
    , 'python': platform.python_version()
    , 'database': a
    , 'redis':  b
    , 'library': c
    , 'APIVersion': vers['APIversion']
    }

  
    return jsonify(statusInfo)


@status_api.route('/lms/api/v1.0/status', methods=['GET'])
def getStatuses():
    """GET gives status of system"""

    statusInfos  = []

    from LMSAPI.api.Views.VersionAPI import getVersion

    x = getVersion()
    import json
    vers = json.loads(x.data.decode("utf-8"))
  
    for z in current_app.ms.listPools():
        st = Status(z)
        a = st.checkDb()
        b = st.checkRedis()
        c = st.checkLibrary()
        statusInfo = {
          'instnace': z
        , 'host': platform.node()
        , 'python': platform.python_version()
        , 'database': a
        , 'redis':  b
        , 'library': c
        , 'APIVersion': vers['APIversion']
        }
        statusInfos.append(statusInfo)
  
    return jsonify(statusInfos)


@status_api.route('/lms/api/v1.0/status/all', methods=['GET'])
def getNodeStatuses():
    """GET gives status of system"""

    statusInfos  = {}

    from urllib.request import urlopen
    import json
    for z in current_app.config['LMSNODES']:
        statusInfos[z] = "ERROR"
        try:
            response = urlopen(z)
            data = response.read().decode("utf-8")        
            statusInfos[z] = json.loads(data)
        except Exception as e:
            s = str(e)
            statusInfos[z] = "ERROR: "  + s

  
    return jsonify(statusInfos)