from flask import Flask, jsonify, request, current_app
from flask_restful import Resource, Api
from flask import Blueprint, url_for
from flask_cors import CORS
import pickle, platform, urllib

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint


version_api = Blueprint("version_api", __name__)

CORS(version_api)


@version_api.route("/lms/api/v1.0/version", methods=["GET"])
def getVersion():
    """GET gives version of system"""

    versionInfo = {
        "APIversion": current_app.version,
        "host": platform.node(),
        "python": platform.python_version(),
    }

    return jsonify(versionInfo)


@version_api.route("/lms/api/v1.0/version/history", methods=["GET"])
def getHistory():
    """GET generate version history"""

    return jsonify(createChangeList())


def createChangeList():
    changeList = []

    versionInfo = {
        "version": "1.0.0",
        "date": "2017-11-01",
        "author": "EN",
        "changes": ["initial commit"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.1",
        "date": "2017-11-08",
        "author": "EN",
        "changes": ["added version history", "added API Cathedra"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.2",
        "date": "2017-11-08",
        "author": "EN",
        "changes": ["added API Year", "added API Group"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.3",
        "date": "2017-11-09",
        "author": "EN",
        "changes": ["Organization API now has Owner"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.4",
        "date": "2017-11-09",
        "author": "EN",
        "changes": ["isTeacher now part of login token result"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.5",
        "date": "2017-11-10",
        "author": "EN",
        "changes": ["/lms/api/v1.0/users/1 will list all teachers"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.6",
        "date": "2017-11-14",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/schema/mid/date will list schema for set date for mid"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.7",
        "date": "2017-11-14",
        "author": "EN",
        "changes": ["fixed isteacher algorithm in token generation"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.8",
        "date": "2017-11-15",
        "author": "EN",
        "changes": ["/year/term/id implemented to get terms"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.9",
        "date": "2017-11-16",
        "author": "EN",
        "changes": ["Group filter /lms/api/v1.0/group/<int:cid>/<int:fid>/<int:yid>"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.10",
        "date": "2017-11-16",
        "author": "EN",
        "changes": [
            "Course  /lms/api/v1.0/course/<int:groupid>/<int:termid>",
            "Course details /lms/api/v1.0/course/<int:id>",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.11",
        "date": "2017-11-17",
        "author": "EN",
        "changes": [
            "Journal /lms/api/v1.0/journal/<int:termid>/<onedate>/<int:courseid>/<int:groupid> termid = 0 uses onedate instead",
            "Token login now include mid",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.12",
        "date": "2017-11-22",
        "author": "EN",
        "changes": ["/lms/api/v1.0/status to get status of system"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.13",
        "date": "2017-11-24",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/group/id return all data needed",
            "token api now return group id for logged on user",
            "/lms/api/v1.0/umk/course/<cid> return courses for given cid",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.14",
        "date": "2017-11-24",
        "author": "EN",
        "changes": ["/lms/api/v1.0/year/edy list education years"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.15",
        "date": "2017-11-28",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/umk/course/<int:cid>/<int:idcurriculum>/<int:syid>/<int:eyid>"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.16",
        "date": "2017-11-28",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/users/<int:id> user details",
            "/lms/api/v1.0/users/<int:id>/photo user photo as jpg stream",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.17",
        "date": "2017-11-29",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/file/People/<int:id> files for user",
            "/lms/api/v1.0/file/People/<int:id>/filename file for user",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.18",
        "date": "2017-11-29",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/search/<name> general search",
            "/lms/api/v1.0/search/u/<name> user search",
            "/lms/api/v1.0/search/c/<name> course search",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.19",
        "date": "2017-11-30",
        "author": "EN",
        "changes": ["/lms/api/v1.0/users/<int:id>/rate user rate "],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.20",
        "date": "2017-12-01",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/schedule/<int:faculty>/<int:educationyear>/<int:schoolyear>/<int:month> get schedule added"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.21",
        "date": "2017-12-01",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/schedule/room/<int:roomid>/<scheduledate> get schedule for room added"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.22",
        "date": "2017-12-04",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/schedule/room/<int:roomid>/<scheduledate> more details for teacher"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.23",
        "date": "2017-12-04",
        "author": "EN",
        "changes": ["user detail now return militaryrank"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.24",
        "date": "2017-12-04",
        "author": "EN",
        "changes": ["More fields for userdetail"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.25",
        "date": "2017-12-05",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/company Company detail",
            "/lms/api/v1.0/company/dep_logo dep logo",
            "/lms/api/v1.0/company/gou_logo gou logo",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.26",
        "date": "2017-12-05",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/schedule/room/<int:roomid>/<scheduledate> now contain cathedra"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.27",
        "date": "2017-12-06",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/company w/o authentication",
            "/lms/api/v1.0/schedule/1/1/23/12 schedule for /lms/api/v1.0/schedule/<int:faculty>/<int:educationyear>/<int:schoolyear>/<int:month> works",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.27",
        "date": "2017-12-07",
        "author": "EN",
        "changes": ["schedule now include lessondate and sorting"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.28",
        "date": "2017-12-07",
        "author": "EN",
        "changes": ["/lms/api/v1.0/token/sso implemented"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.29",
        "date": "2017-12-08",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/token/sso now read X-LMS-SECRET header if SSO-SECRET is set in config",
            "Sort schedule after group",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.30",
        "date": "2017-12-08",
        "author": "EN",
        "changes": ["Now sort schedule in a data tree"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.31",
        "date": "2017-12-13",
        "author": "EN",
        "changes": ["schema listing now contain faculty "],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.32",
        "date": "2017-12-14",
        "author": "EN",
        "changes": ["Rating sorting corrected"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.33",
        "date": "2017-12-15",
        "author": "EN",
        "changes": ["Schedule - lessondate new formatting"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.34",
        "date": "2017-12-15",
        "author": "TS",
        "changes": ["Course - get all courses without filters"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.35",
        "date": "2017-12-18",
        "author": "TS",
        "changes": ["schedule new fields (rooms, teacher, lessontype etc)"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.36",
        "date": "2017-12-20",
        "author": "EN",
        "changes": ["Patch to remove @ in sso"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.37",
        "date": "2017-12-21",
        "author": "TS",
        "changes": ["Patch for schedule month filter"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.38",
        "date": "2017-12-25",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/settings returns if basic login is allowed on 401 response from /token/sso"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.39",
        "date": "2018-01-09",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/[INSTANCENAME]/call now in effect. All calls should include INSTANCENAME"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.40",
        "date": "2018-01-10",
        "author": "EN",
        "changes": ["Token now works again"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.41",
        "date": "2018-01-10",
        "author": "EN",
        "changes": ["Bugfix schedule"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.42",
        "date": "2018-01-17",
        "author": "EN",
        "changes": ["Bugfix schedule"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.43",
        "date": "2018-01-18",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/gradebook/<int:uid>/<int:semesterid> gradebook implemented"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.44",
        "date": "2018-01-18",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/progress/<int:uid>/<int:yearid> progress implemented",
            "/lms/api/v1.0/<lname>/progress_detail/<int:uid>/<int:semesterid>/<int:courseid> progress details implemented",
            "/lms/api/v1.0/<lname>/methodical/<int:facultyid>/<int:studentid> methodical implemented",
            "/lms/api/v1.0/<lname>/methodical/<int:facultyid>/<int:studentid>/<int:mrid> methodical implemented",
            "/lms/api/v1.0/<lname>/methodical/<int:facultyid>/<int:studentid>/<int:mrid>/<filename> methodical implemented",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.45",
        "date": "2018-01-18",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/gradebook/<int:uid>/<int:semesterid> gradebook grouping by year, term"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.46",
        "date": "2018-01-19",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/status/all to get info about a cluster",
            "empty schedule causes 500 fixed",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.47",
        "date": "2018-01-31",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/group/<int:cid>/<int:fid>/<int:yid>/<int:educationyid> group api new parameter - educationyearid - leave 0 for no relevance",
            "/lms/api/v1.0/<lname>/schedule/u/<int:mid>/<scheduledate> call for schedule - user",
            "/lms/api/v1.0/<lname>/schedule/g/<int:mid>/<scheduledate> call for schedule - group",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.48",
        "date": "2018-01-31",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/schedule/u/<int:mid>/<scheduledate> now show only for a date - not week",
            "/lms/api/v1.0/<lname>/schedule/g/<int:mid>/<scheduledate> now show only for a date - not week",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.49",
        "date": "2018-02-01",
        "author": "EN",
        "changes": ["Removed unneeded configuration items"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.50",
        "date": "2018-02-05",
        "author": "EN",
        "changes": [
            "UMK Course details now return files for course and study year under files and commonFiles[eyid][tlid]",
            "Get file for course lms/api/v1.0/<lname>/umk/course/files/<int:idcurriculum>/<int:eyid>/<int:tlid>/<oid>/<filename> , oid=0 for semesterFiles, _1 for testFiles, _2 for gradedTestFiles, _3 for examFiles",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.51",
        "date": "2018-02-05",
        "author": "EN",
        "changes": ["Cathedra list bug fix"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.52",
        "date": "2018-02-05",
        "author": "EN",
        "changes": ["Journal put all dates"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.53",
        "date": "2018-02-27",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/umk/course/<int:cid> now deliver id_curriculum_course which should be used to get files for UMK",
            "Change: use id_curriculum_course (from previous call) instead of idcurriculum when getting file on /lms/api/v1.0/<lname>/umk/course/files/<int:id_curriculum_course>/<int:eyid>/<int:tlid>/<oid>/<filename>",
            "/lms/api/v1.0/<lname>/users/<int:id> include home phone",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.54",
        "date": "2018-02-28",
        "author": "EN",
        "changes": ["Re-enable cache on umk/course"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.55",
        "date": "2018-03-06",
        "author": "EN",
        "changes": ["500 in schedule if school year does not exist replaced by 404"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.56",
        "date": "2018-03-06",
        "author": "EN",
        "changes": [
            "If militaryprofession is null, now educationplan is null instead of non existing"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.57",
        "date": "2018-03-12",
        "author": "EN",
        "changes": [
            "GET /lms/api/v1.0/<lname>/message - Get count of unread messages",
            "POST /lms/api/v1.0/<lname>/message/users search users (json: user)",
            "GET /lms/api/v1.0/<lname>/message/chat get chats",
            "POST /lms/api/v1.0/<lname>/message/chat (json: tomid , title)",
            "GET /lms/api/v1.0/<lname>/message/chat/<int:id> get info about chat",
            "GET /lms/api/v1.0/<lname>/message/chat/<int:id>/message get messages for chat ID",
            "POST /lms/api/v1.0/<lname>/message/chat/<int:id>/message post chat message (json: parent (parent message id, 0 for root), message)",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.58",
        "date": "2018-03-16",
        "author": "EN",
        "changes": [
            "GET /lms/api/v1.0/<lname>/message - Get count of unread messages",
            "POST /lms/api/v1.0/<lname>/message/users search users (json: user)",
            "GET /lms/api/v1.0/<lname>/message/chat get chats",
            "POST /lms/api/v1.0/<lname>/message/chat (json: tomid , title)",
            "GET /lms/api/v1.0/<lname>/message/chat/<int:id> get info about chat",
            "GET /lms/api/v1.0/<lname>/message/chat/<int:id>/message get messages for chat ID",
            "POST /lms/api/v1.0/<lname>/message/chat/<int:id>/message post chat message (json: parent (parent message id, 0 for root), message)",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.59",
        "date": "2018-03-22",
        "author": "EN",
        "changes": [
            "DELETE /lms/api/v1.0/<lname>/message/chat/<int:id> delete chat - only if owner of chat",
            "DELETE /lms/api/v1.0/<lname>/message/chat/<int:id>/message/<int:messageid> delete chat message (only if owner of message)",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.60",
        "date": "2018-03-28",
        "author": "EN",
        "changes": ["/lms/api/v1.0/<lname>/ooop get OOOP data for logged on user"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.61",
        "date": "2018-03-29",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/ooop OOOP data include calculated average and competence level"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.62",
        "date": "2018-03-29",
        "author": "EN",
        "changes": [
            'POST /lms/api/v1.0/<lname>/message/chat (json: tomid , title,message) ADDED MESSAGE FOR CREATING A CHAT - if message != "" , a message is also created under the subject of "title"'
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.63",
        "date": "2018-03-29",
        "author": "EN",
        "changes": [
            "GET /lms/api/v1.0/<lname>/specialty/ get list of militaryprofession",
            "GET /lms/api/v1.0/<lname>/specialty/<int:id> for militaryprofession with mpid=id ",
            "GET /lms/api/v1.0/<lname>/curriculum/<int:syid>/<int:mpid> get curiiculum with study year and military profesison id",
            "GET /lms/api/v1.0/<lname>/curriculum/<int:id> get curriculum details with certain id",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.64",
        "date": "2018-03-29",
        "author": "EN",
        "changes": [
            "GET /lms/api/v1.0/<lname>/testtype get test types",
            "GET /lms/api/v1.0/<lname>/testresult/<int:semester>/<int:courseid>/<int:groupid>/<int:testtype> get test results",
            "GET /lms/api/v1.0/<lname>/testresult/<int:jcid>/<filename> get test file",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.65",
        "date": "2018-03-30",
        "author": "EN",
        "changes": ["/company now give png images instead of jpg"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.66",
        "date": "2018-04-07",
        "author": "EN",
        "changes": [
            "/company now give png images instead of jpg and jpg if no png",
            "Backport for python3.5",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.67",
        "date": "2018-04-23",
        "author": "EN",
        "changes": ["Bugfix in journal"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.68",
        "date": "2018-05-22",
        "author": "EN",
        "changes": ["Bugfix in messages"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.69",
        "date": "2018-08-16",
        "author": "EN",
        "changes": ["Rounding error in grade corrected"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.70",
        "date": "2018-08-20",
        "author": "EN",
        "changes": ["Grade 500 fied", "message 500 fixed", "token sso 401 fixed"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.71",
        "date": "2018-09-04",
        "author": "EN",
        "changes": [
            "Message counter increasing on own messages fixed",
            "photoId implemented on GET chats",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.72",
        "date": "2018-09-11",
        "author": "EN",
        "changes": ["reworked token to not give 201"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.73",
        "date": "2018-09-26",
        "author": "EN",
        "changes": ["cathedraid / facultyid added to user properties"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.74",
        "date": "2018-09-28",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/portfolio/<int:id> GET / POST for portfolio",
            "/lms/api/v1.0/<lname>/portfolio/file/<int:mid> list files for portfolio",
            "/lms/api/v1.0/<lname>/portfolio/file/<int:mid>/<filename> get file ",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.75",
        "date": "2018-10-01",
        "author": "EN",
        "changes": [
            "Empty file listing now return [] and not null",
            "Filesize included in file listings (size)",
            '/lms/api/v1.0/<lname>/portfolio/file/<int:mid> POST - upload file with key "file" as form-data ',
            "/lms/api/v1.0/<lname>/portfolio/file/<int:mid>/<filename> DELETE file ",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.76",
        "date": "2018-10-01",
        "author": "EN",
        "changes": [
            "Empty file listing now return [] and not null",
            "Create (portfolio) directory if not exist during upload",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.77",
        "date": "2018-10-03",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/links will provide a list and links to icons of links to present on main page",
            "/lms/api/v1.0/<lname>/links/id will get icon for link",
            "added cache-control for images, 1 day cache for images",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.78",
        "date": "2018-10-04",
        "author": "EN",
        "changes": ["Schedule teacher different output format"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.79",
        "date": "2018-10-08",
        "author": "EN",
        "changes": ["User output changed", "Log of login to table"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.79",
        "date": "2018-10-08",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/current_performance/<termid>/<mid>/<cid> current performance implemented"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.81",
        "date": "2018-10-09",
        "author": "EN",
        "changes": [
            "Homework implemented",
            "/lms/api/v1.0/<lname>/homework/user/<int:id>/<int:sheid>/<int:instance> GET user homework",
            "/lms/api/v1.0/<lname>/homework/user/<int:userId>/<int:sheid>/<int:instance>/<filename> GET user homework file",
            "/lms/api/v1.0/<lname>/homework/userresult/<int:id>/<int:sheid>/<int:instance> GET POST user homework result / file",
            "/lms/api/v1.0/<lname>/homework/userresult/<int:userId>/<int:sheid>/<int:instance>/<filename> GET DELETE  user homework result file",
            "/lms/api/v1.0/<lname>/homework/group/<int:sheid>/<int:instance> GET group homework files",
            "/lms/api/v1.0/<lname>/homework/group/<int:sheid>/<int:instance>/<filename> GET group homework file",
            "/lms/api/v1.0/<lname>/homework/groupresult/<int:id>/<int:sheid>/<int:instance> GET POST group homework result files",
            "/lms/api/v1.0/<lname>/homework/groupresult/<int:userId>/<int:sheid>/<int:instance>/<filename> GET DELETE group homework result",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.82",
        "date": "2018-10-09",
        "author": "EN",
        "changes": ["/lms/api/v1.0/<lname>/users/students list students"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.83",
        "date": "2018-10-10",
        "author": "EN",
        "changes": ["Fixed bug in token re-generation using token"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.84",
        "date": "2018-10-15",
        "author": "EN",
        "changes": ["Fixed bug in schedule"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.85",
        "date": "2018-10-15",
        "author": "EN",
        "changes": ["schedule now include short_name for room"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.86",
        "date": "2018-10-16",
        "author": "EN",
        "changes": ["fix eyid in UMKCourse to send correct id"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.87",
        "date": "2018-10-31",
        "author": "EN",
        "changes": ["Generation of grades not working. Fixed."],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.88",
        "date": "2018-10-31",
        "author": "EN",
        "changes": ["Left join faculty fixed"],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.89",
        "date": "2018-11-09",
        "author": "EN",
        "changes": ["Current performance sorting by lessondate"],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.90",
        "date": "2018-11-09",
        "author": "EN",
        "changes": [
            "gradebook changes",
            "GET /lms/api/v1.0/<lname>/progress_total/<int:uid>/<int:yearid> new call",
            "/lms/api/v1.0/<lname>/current_performance/<termid>/<mid>/<cid> now include if files exist in homework",
        ],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.91",
        "date": "2018-11-14",
        "author": "EN",
        "changes": ["studentproject implemented"],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.92",
        "date": "2018-11-19",
        "author": "EN",
        "changes": ["write to LocalInfo"],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.93",
        "date": "2018-11-21",
        "author": "EN",
        "changes": [
            "Bug in put student project result",
            "student project api - improved error messages",
        ],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.93",
        "date": "2018-11-26",
        "author": "EN",
        "changes": [
            "POST /lms/api/v1.0/<lname>/users/password JSON Parameters: oldpassword , newpassword"
        ],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.94",
        "date": "2018-11-29",
        "author": "EN",
        "changes": ["need_change_password included in token"],
    }
    changeList.append(versionInfo)

    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.95",
        "date": "2018-12-04",
        "author": "EN",
        "changes": ["umkcourse include now curriculum_name"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.96",
        "date": "2018-12-07",
        "author": "EN",
        "changes": ["Issue in StudentProject API"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.97",
        "date": "2018-12-07",
        "author": "EN",
        "changes": ["Issue in StudentProject API (grade)"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.98",
        "date": "2018-12-12",
        "author": "EN",
        "changes": ["More fields in UMKCourse"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.99",
        "date": "2018-12-12",
        "author": "EN",
        "changes": [
            "Get teacher schedule /lms/api/v1.0/<lname>/schedule/t/<int:mid>/<int:weekid>",
            "/lms/api/v1.0/<lname>/year/week/<int:studyyear> get week list",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.100",
        "date": "2018-12-13",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/users/<int:id> extended with teacherDetails"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.101",
        "date": "2018-12-18",
        "author": "EN",
        "changes": ["/lms/api/v1.0/<lname>/journal/grade POST grade"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.102",
        "date": "2019-01-15",
        "author": "TS",
        "changes": [
            "/lms/api/v1.0/<lname>/curriculum GET",
            "/lms/api/v1.0/<lname>/course/curriculum/<int:curriculumid> GET courses list by curriculum",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.103",
        "date": "2019-01-15",
        "author": "TS",
        "changes": ["/lms/api/v1.0/<lname>/umk/<int:cid>/<int:idcurriculum> GET"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.104",
        "date": "2019-01-21",
        "author": "TS",
        "changes": ["/lms/api/v1.0/<lname>/umk/<int:id> GET"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.105",
        "date": "2019-01-23",
        "author": "TS",
        "changes": [
            "/lms/api/v1.0/<lname>/journal_rashod/<onedate>/<int:groupid> GET",
            "/lms/api/v1.0/<lname>/journal/grade_values/absent GET",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.106",
        "date": "2019-01-23",
        "author": "TS",
        "changes": ["/lms/api/v1.0/<lname>/umk/<int:id>/links/<int:type> GET"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.107",
        "date": "2019-01-23",
        "author": "TS",
        "changes": [
            "/lms/api/v1.0/<lname>/umk/<int:id>/edu_plan GET",
            "/lms/api/v1.0/<lname>/umk/<int:id>/work_program GET",
            "/lms/api/v1.0/<lname>/umk/<int:id>/tema_plan GET",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.108",
        "date": "2019-01-24",
        "author": "TS",
        "changes": [" fixing /lms/api/v1.0/<lname>/umk/<int:id>/tema_plan GET"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.109",
        "date": "2019-01-25",
        "author": "TS",
        "changes": [" fixing /lms/api/v1.0/<lname>/umk/<int:id>/work_program GET"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.110",
        "date": "2019-02-28",
        "author": "TS",
        "changes": [
            " fixing /lms/api/v1.0/<lname>/group/teacher/<int:cid>/<int:trimid> GET"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.111",
        "date": "2019-03-01",
        "author": "TS",
        "changes": [
            " added new call (courses for logined student) /lms/api/v1.0/<lname>/course/student/<int:trmid GET"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.112",
        "date": "2019-03-03",
        "author": "TS",
        "changes": [" new api for homework group and student"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.113",
        "date": "2019-03-07",
        "author": "TS",
        "changes": ["fixing journal api"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.114",
        "date": "2019-03-11",
        "author": "TS",
        "changes": ["fixing journal api (lists of Homework files)"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.115",
        "date": "2019-03-13",
        "author": "EN",
        "changes": ["fixing bug in Homework read file (access right) GET file"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.116",
        "date": "2019-03-14",
        "author": "EN",
        "changes": ["UMKCourse listing tree issue"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.117",
        "date": "2019-03-14",
        "author": "EN",
        "changes": ["UMKCourse listing tree issues"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.118",
        "date": "2019-05-05",
        "author": "EN",
        "changes": ["Python 2.7 adaptions"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.119",
        "date": "2019-05-30",
        "author": "EN",
        "changes": ["Python 2.7 adaptions 3.5 adaptions"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.120",
        "date": "2019-05-30",
        "author": "EN",
        "changes": ["secure_filename does not work with cyrillic"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.121",
        "date": "2019-08-22",
        "author": "EN",
        "changes": ["library integration"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.122",
        "date": "2019-08-23",
        "author": "EN",
        "changes": ["library integration"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.123",
        "date": "2019-08-26",
        "author": "EN",
        "changes": ["library integration libraryactive / url on token request"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.124",
        "date": "2019-09-01",
        "author": "EN",
        "changes": ["library integration libraryactive / url on token request bug"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.125",
        "date": "2019-09-01",
        "author": "EN",
        "changes": ["library integration libraryactive / url on token request bug"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.126",
        "date": "2019-09-04",
        "author": "EN",
        "changes": ["photosize listing user details", "photosize listing teachers"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.127",
        "date": "2019-09-19",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/coursebooks/<int:id_curriculum_course> GET",
            "/lms/api/v1.0/<lname>/coursebooks/<int:id_curriculum_course> POST (json: part, num, razdel, library_bookid)",
            "/lms/api/v1.0/<lname>/coursebooks/<int:id> DELETE",
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.128",
        "date": "2019-09-19",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/coursebooks/<int:id> PUT (json: part, num, razdel, library_bookid)"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.130",
        "date": "2019-09-20",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/educationworkprogram/:idcurriculum/:courseid"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.131",
        "date": "2019-10-03",
        "author": "EN",
        "changes": ["Bugfix: biblio integration"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.132",
        "date": "2019-10-17",
        "author": "EN",
        "changes": [
            "POST /lms/api/v1.0/<lname>/token for login (json: username / password)"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.133",
        "date": "2019-10-21",
        "author": "EN",
        "changes": ["Bugfix: group photosize serialization"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.134",
        "date": "2019-11-13",
        "author": "EN",
        "changes": ["Bugfix: group search"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.135",
        "date": "2019-11-25",
        "author": "EN",
        "changes": ["include teacher_mids, cathedra in schedule response"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.136",
        "date": "2019-11-28",
        "author": "EN",
        "changes": ["API key"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.137",
        "date": "2019-11-28",
        "author": "EN",
        "changes": ["API key lock down"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.138",
        "date": "2019-11-29",
        "author": "EN",
        "changes": ["/coursebooks change"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.139",
        "date": "2019-12-03",
        "author": "EN",
        "changes": ["SCY dateformat"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.140",
        "date": "2019-12-03",
        "author": "EN",
        "changes": ["GET ../users/teachers ?count  / ?paginateFrom=0&maxResults=100 "],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.141",
        "date": "16-01-2020",
        "author": "EN",
        "changes": ["GET /lms/api/v1.0/penza/booksupply/:schoolyear"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.142",
        "date": "21-01-2020",
        "author": "EN",
        "changes": ["GET /lms/api/v1.0/penza/booksupply/:schoolyear format"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.143",
        "date": "28-01-2020",
        "author": "EN",
        "changes": ["Python2.7 urlencode"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.144",
        "date": "28-01-2020",
        "author": "EN",
        "changes": ["CurrentPerformance - instance >0 "],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.145",
        "date": "11-02-2020",
        "author": "EN",
        "changes": [
            "/lms/api/v1.0/<lname>/educationworkprogram/<int:idcurriculum>/<int:courseid>?id_curriculum_course=xxxx"
        ],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.146",
        "date": "12-02-2020",
        "author": "EN",
        "changes": ["/lms/api/v1.0/<lname>/booksupply/:id?flat=true"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.147",
        "date": "11-06-2020",
        "author": "EN",
        "changes": ["Python 2.7 issues in UMK, photo, portfolio, schedule"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.149",
        "date": "27-07-2020",
        "author": "EN",
        "changes": ["Python 2.7 issues in UMK", "contact in user"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.149",
        "date": "7-08-2020",
        "author": "EN",
        "changes": ["rfid_token login"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.149",
        "date": "2-11-2020",
        "author": "TS",
        "changes": ["misc changes"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.150",
        "date": "13-11-2020",
        "author": "EN",
        "changes": ["Python2.7 Unicode/Library integration issue"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.151",
        "date": "16-02-2021",
        "author": "EN",
        "changes": ["rfid_token login #2"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.152",
        "date": "11-03-2021",
        "author": "TS",
        "changes": ["no auth schedule"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.153",
        "date": "28-07-2021",
        "author": "TS",
        "changes": ["apikey calls for room schedule"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.154",
        "date": "02-08-2021",
        "author": "TS",
        "changes": ["room api"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.155",
        "date": "01-09-2021",
        "author": "TS",
        "changes": ["small changes"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.156",
        "date": "01-10-2021",
        "author": "TS",
        "changes": ["getStartAndEnddate fix"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.157",
        "date": "18-10-2021",
        "author": "TS",
        "changes": ["birthday"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.158",
        "date": "19-10-2021",
        "author": "TS",
        "changes": ["students POST"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.159",
        "date": "20-10-2021",
        "author": "TS",
        "changes": ["teacher bithday, bithday date format"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.160",
        "date": "25-10-2021",
        "author": "TS",
        "changes": ["group list, students by group"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.161",
        "date": "16-11-2021",
        "author": "TS",
        "changes": ["library book url"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.162",
        "date": "10-01-2022",
        "author": "TS",
        "changes": ["new route /lms/api/v1.0/<lname>/termlist/<int:id>"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.163",
        "date": "10-01-2022",
        "author": "TS",
        "changes": ["new route /lms/api/v1.0/<lname>/rpd/subjects/"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.164",
        "date": "13-05-2022",
        "author": "TS",
        "changes": ["ratings"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.165",
        "date": "22-08-2022",
        "author": "TS",
        "changes": ["edu docs"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.166",
        "date": "10-10-2022",
        "author": "TS",
        "changes": ["divisions"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.167",
        "date": "07-02-2023",
        "author": "BI",
        "changes": ["rename user_is_jornal_admin to user_is_rasdel_admin"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.168",
        "date": "03-03-2023",
        "author": "TS",
        "changes": ["new api route /chiefs, /news"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.169",
        "date": "10-03-2023",
        "author": "TS",
        "changes": ["holidays"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.170",
        "date": "13-03-2023",
        "author": "TS",
        "changes": ["news parts and images"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.171",
        "date": "17-03-2023",
        "author": "TL",
        "changes": ["news endpoint for biography"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.172",
        "date": "30-03-2023",
        "author": "BI",
        "changes": ["add meta_course_name to getCourse"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.173",
        "date": "04-04-2023",
        "author": "BI",
        "changes": ["add room_by_date /lms/api/v1.0/<lname>/room/date/<string:date>"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.174",
        "date": "05-04-2023",
        "author": "BI",
        "changes": ["add api for room files photo and panorama"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.175",
        "date": "06-04-2023",
        "author": "BI",
        "changes": ["add api for hero posts"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.176",
        "date": "07-04-2023",
        "author": "BI",
        "changes": ["add api for combat training tasks"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.177",
        "date": "11-04-2023",
        "author": "BI",
        "changes": ["HLMS-2925"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.178",
        "date": "13-04-2023",
        "author": "BI",
        "changes": [
            "HLMS-2925, add new methods for upload and download files in class File"
        ],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.179",
        "date": "05-05-2023",
        "author": "BI",
        "changes": ["fix user_action_log if no user login"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.180",
        "date": "22-05-2023",
        "author": "BI",
        "changes": ["fix get body from request in create faculty"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.181",
        "date": "22-05-2023",
        "author": "BI",
        "changes": ["HLMS-3149"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.182",
        "date": "30-05-2023",
        "author": "BI",
        "changes": ["HLMS-3149, fix meta_course_name in get course"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.183",
        "date": "20-07-2023",
        "author": "BI",
        "changes": ["HLMS-3322, new endpoint for groups in journal"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.184",
        "date": "08-02-2024",
        "author": "TA",
        "changes": ["Cameras"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.185",
        "date": "26-04-2024",
        "author": "TA",
        "changes": ["journal grade values"],
    }
    changeList.append(versionInfo)
    
    versionInfo = {
        "version": "1.0.186",
        "date": "26-04-2024",
        "author": "EN",
        "changes": ["UMK List missing - reinstated"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.0.187",
        "date": "09-01-2025",
        "author": "EN",
        "changes": ["RBAC on PGP&Import applicant","ALSE1.6 gpg issue"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.188",
        "date": "10-01-2025",
        "author": "EN",
        "changes": ["Support .tar file"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.0.19",
        "date": "13-01-2025",
        "author": "EN",
        "changes": ["Filter for applicant"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.3.2.289",
        "date": "17-01-2025",
        "author": "AG",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.290",
        "date": "21-01-2025",
        "author": "EN",
        "changes": ["Timestamp date on xp_applicant"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.291",
        "date": "05-02-2025",
        "author": "EN",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.292",
        "date": "23-02-2025",
        "author": "TS",
        "changes": ["Dashboard fix"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.293",
        "date": "23-02-2025",
        "author": "TS",
        "changes": ["Dashboard fix"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.294",
        "date": "28-03-2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.295",
        "date": "02.04.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.296",
        "date": "21.04.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.297",
        "date": "26.05.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.298",
        "date": "04.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.299",
        "date": "10.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.301",
        "date": "09.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.302",
        "date": "09.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.303",
        "date": "09.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.304",
        "date": "09.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.305",
        "date": "09.06.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)
    versionInfo = {
        "version": "1.3.2.306",
        "date": "16.10.2025",
        "author": "TS",
        "changes": ["Degree candidates API"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.3.2.307",
        "date": "30.10.2025",
        "author": "TS",
        "changes": ["Dashboard API"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.3.2.308",
        "date": "06.11.2025",
        "author": "TS",
        "changes": ["Dashboard API"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.3.2.309",
        "date": "20.11.2025",
        "author": "EN",
        "changes": ["GPG Import API"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.3.2.310",
        "date": "1.03.2025",
        "author": "EN",
        "changes": ["GPG Import API"],
    }
    changeList.append(versionInfo)

    versionInfo = {
        "version": "1.3.2.311",
        "date": "16.12.2025",
        "author": "EN",
        "changes": ["GPG Import API"],
    }
    changeList.append(versionInfo)

    return changeList
