from datetime import datetime

from flask import Flask, jsonify, request, current_app
from flask_restful import Resource, Api
from sqlalchemy import create_engine
from sqlalchemy.sql import text
from flask import Blueprint

from LMSAPI.api.Models.Educationyear import Educationyear
from LMSAPI.api.Views.TokenAPI import auth
from LMSAPI.api.Models.User import User
from LMSAPI.api.Models.Studyyear import Studyyear
from LMSAPI.api.Models.Schoolyear import Schoolyear
from LMSAPI.api.Models.Term import Term
from flask_cors import CORS

from LMSAPI.api.utils.swagger_comments import SwaggerComments
from LMSAPI.api.utils.swagger_utils import swagger_doc

# https://stackoverflow.com/questions/39769666/flask-how-to-use-app-context-inside-blueprints
# Use app context from blueprint

year_api = Blueprint("year_api", __name__)

CORS(year_api)


@year_api.route("/lms/api/v1.0/<lname>/terms", methods=["GET"])
@auth.login_required
def get_term_list(lname):
    date = request.args.get(
        "date", default=datetime.now().strftime("%d-%m-%Y"), type=str
    )
    result = Term(lname).get_term_list(date=date)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/term/<int:id>", methods=["GET"])
def getTermList(lname, id):
    """GET list StudyYears"""
    result = Term(lname).getTermList(id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route(
    "/lms/api/v1.0/<lname>/year/term/<int:school_year>/<int:idfaculty>/<int:idcurriculum>/<int:eyid>",
    methods=["GET"],
)
@auth.login_required
def getTermByYearFacultyCurriculumKurs(
    lname, school_year, idfaculty, idcurriculum, eyid
):
    """GET list StudyYears"""
    result = Term(lname).getTermByYearFacultyCurriculumKurs(
        school_year, idfaculty, idcurriculum, eyid
    )

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/termlist/<int:id>", methods=["GET"])
@auth.login_required
def getTermsList(lname, id):
    result = Term(lname).getTermsList(id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/sy", methods=["GET"])
@auth.login_required
def getStudyYearList(lname):
    """GET list StudyYears"""
    result = Studyyear(lname).getStudyYearList()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/sy/<int:id>", methods=["GET"])
@auth.login_required
def getStudyYear(lname, id):
    """GET with ID to get info on a study year"""
    result = Studyyear(lname).getStudyYear(id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/scy", methods=["GET"])
@swagger_doc(SwaggerComments.year_api_getSchoolYearList)
def getSchoolYearList(lname):
    """
    Получить список учебных годов
    """
    result = Schoolyear(lname).getSchoolYearList()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/scy/<int:id>", methods=["GET"])
@auth.login_required
def getSchoolYear(lname, id):
    """GET with ID to get info on a SchoolYear"""
    result = Schoolyear(lname).getSchoolYear(id)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/edy", methods=["GET"])
@swagger_doc(SwaggerComments.year_api_getEducationYear)
def getEducationYear(lname):
    """
    Получить список возможных курсов обучения
    """
    from LMSAPI.api.Models.Educationyear import Educationyear

    ey = Educationyear(lname)
    result = ey.getEducationYearList()

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route(
    "/lms/api/v1.0/<lname>/year/edy/<int:school_year>/<int:idfaculty>/<int:idcurriculum>",
    methods=["GET"],
)
@auth.login_required
def getEducationYearByYearFacultyCurriculum(
    lname, school_year, idfaculty, idcurriculum
):
    """GET list of EducationYear"""
    from LMSAPI.api.Models.Educationyear import Educationyear

    ey = Educationyear(lname)
    result = ey.getEducationYearByYearFacultyCurriculum(
        school_year, idfaculty, idcurriculum
    )

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)


@year_api.route(
    "/lms/api/v1.0/<lname>/year/edy/<int:xp_key>",
    methods=["GET"],
)
@auth.login_required
@swagger_doc(SwaggerComments.year_api_get_education_year_by_school_year)
def get_education_year_by_school_year(
    lname, xp_key
):
    """
    Получить список курсов обучения по учебному году
    """
    result = Educationyear(lname).get_education_year_by_school_year(
        xp_key
    )
    if result is None:
        return jsonify(success=False), 404
    return jsonify(result)


@year_api.route("/lms/api/v1.0/<lname>/year/week/<int:studyyear>", methods=["GET"])
def getWeek(lname, studyyear):
    from LMSAPI.api.Models.Week import Week

    ey = Week(lname)
    result = ey.getWeekList(studyyear)

    if result is None:
        return jsonify(success=False), 404

    return jsonify(result)
