from functools import wraps

from flask import current_app, g, jsonify, request
from sqlalchemy import text

from config import Config


class AccessUtils:
    @staticmethod
    def get_allowed_modes(lname, user_id):
        sql = """
            SELECT  
               parent.Name RasdelName,  
               xp_access_rasdel.Name ObjectName,  
               CASE Max(FIND_IN_SET(xp_access.value, 'Нет,Чтение,Полный')) 
               WHEN 2 THEN 'Чтение' 
               WHEN 3 THEN 'Полный' 
               ELSE 'Нет' 
               END "value" 
             FROM xp_access 
             INNER JOIN xp_access_rasdel ON xp_access_rasdel.xp_Key = xp_access.Rasdel 
             INNER JOIN xp_access_rasdel parent ON xp_access_rasdel.parent = parent.xp_Key 
               AND parent.parent = 0 AND parent.xp_Key <>  21
             INNER JOIN permission2mid ON xp_access.Role = permission2mid.pmid AND permission2mid.mid = :user_id
             GROUP BY RasdelName, ObjectName 
             UNION 
             SELECT 
               parent.Name RasdelName, 
               xp_report.Name ObjectName, 
               CASE Max(FIND_IN_SET(xp_access.value, 'Нет,Чтение,Полный')) 
               WHEN 2 THEN 'Чтение' 
               WHEN 3 THEN 'Полный' 
               ELSE 'Нет' 
               END "value" 
             FROM xp_access 
             INNER JOIN xp_report ON xp_report.xp_rpt_id = xp_access.Report_id 
             INNER JOIN xp_access_rasdel parent ON xp_access.Rasdel = parent.xp_Key 
               AND parent.parent = 0 AND parent.xp_Key =  21
             INNER JOIN permission2mid ON xp_access.Role = permission2mid.pmid AND permission2mid.mid = :user_id
             GROUP BY RasdelName, ObjectName
        """

        conn = current_app.ms.db(lname).connect()

        stmt = text(sql)
        stmt = stmt.bindparams(user_id=user_id)

        query = conn.execute(stmt)

        result = {}
        for access_mode in query.cursor:
            print(access_mode)
            result[access_mode[1]] = dict(zip(tuple(query.keys()), access_mode))
        return result


def user_permission_modes(mode: str, part: str, permission: list):
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            if request.args.get('apikey'):
                if current_app.ms.getapikey(kwargs['lname']) == request.args['apikey']:
                    return func(*args, **kwargs)
                return jsonify(message="Доступ запрещен"), 400
            try:
                if g.user.access_modes[mode][part] in permission:
                    return jsonify(message="Доступ запрещен"), 400
            except TypeError:
                return jsonify(message="У пользователя нет роли"), 400
            except KeyError:
                return jsonify(message="У пользователя нет роли"), 400
            return func(*args, **kwargs)

        return wrapper

    return decorator
