from LMSAPI.api.utils.gpghelper import getKeyData , decodeFile, importPrivateKey
import hashlib
import csv,os,stat
from pathlib import Path


def importPGPKey(keydata, serial, keyname, force = False):

    keys = getKeyData(secret=True)
    if(len(keys) != 0 and force is not True):
        return { "result": "error", "error": "Ключ уже существует", "key": keys}

    ztring = serial + keyname
    password = hashlib.sha256(ztring.encode('utf-8')).hexdigest()
    importResult = importPrivateKey(keydata,password)
    if importResult != None:
        return { "result": "error", "error": "Ключ не импортирован " + importResult, "key": None}
    
    keys = getKeyData(secret=True)
    return { "result": "ok", "key": keys}


def statusPGPKey():
    keys = getKeyData(secret=True)

    if len(keys)==0:
        return { "result": "error", "error": "Нет ключей GPG"}
    
    keys = getKeyData(secret=True)
    return { "result": "ok", "key": keys}


def decryptPGPFile(file,serial,keyname):
    ztring = serial + keyname
    password = hashlib.sha256(ztring.encode('utf-8')).hexdigest()
    result = decodeFile(file,password)
    return result

