/*
oliver, 02.06.2022.
В эталонной БД (studium) был добавлен столбец Sustenance («Критерий содержания») типа smallint
в таблицу Positions («Должности»). Он может принимать значения NULL. Затем для уже существующих
записей, если они имеют Positions.Razdel = 0, т.е. относятся к «Дополнительному классификатору
двойных должностей», значения в новом столбце Positions.Sustenance были заменены с NULL на 0.
Этот 0 в коде лазарьского приложения HLMS трактуется как содержание «без классификации» —
значение по умолчанию для этого поля, если должность принадлежит к «Дополнительному
классификатору двойных должностей» (для других должностей по умолчанию — NULL, поэтому
столбцу Positions.Sustenance не придаётся никакого свойства DEFAULT средствами БД).
*/

DO $$
declare
  _column_exists boolean;
  _db_name varchar(63);
  _msg varchar(255);

BEGIN

SELECT exists(SELECT 1 FROM information_schema.columns col WHERE col.table_name ilike 'positions' AND col.column_name ilike 'sustenance')
  into _column_exists;

SELECT current_database()
  INTO _db_name;

_msg := 'БД ' || _db_name || '.' || E'\n';

if (_column_exists) then
  _msg := _msg || 'Столбец Positions.Sustenance уже существует, ничего не делаем.' || E'\n';
else
  alter table Positions add column Sustenance smallint;
  update Positions set Sustenance = 0 where coalesce(Razdel, 0) = 0 and Sustenance is null;
  _msg := _msg || 'Создали столбец Positions.Sustenance и заполнили нулями для двойных должностей.' || E'\n';
end if;

if (not _column_exists) then
  SELECT exists(SELECT 1 FROM information_schema.columns col WHERE col.table_name ilike 'positions' AND col.column_name ilike 'sustenance')
    into _column_exists;
  
  if (_column_exists) then
    _msg := _msg || 'Снова проверили: теперь столбец Positions.Sustenance точно существует!';
  else
    _msg := _msg || 'Это провал! Столбца Positions.Sustenance по-прежнему нет!!!';
  end if;
end if;

raise notice '%', _msg;

END $$;

/*
select * from Positions order by Sustenance;
--*/
